#! /usr/bin/python
"""
* Copyright 2001-2012 Broadcom Corporation -- http://www.broadcom.com
* This program is the proprietary software of Broadcom Corporation and/or
* its licensors, and may only be used, duplicated, modified or distributed
* pursuant to the terms and conditions of a separate, written license
* agreement executed between you and Broadcom (an "Authorized License").
* Except as set forth in an Authorized License, Broadcom grants no license
* (express or implied), right to use, or waiver of any kind with respect to
* the Software, and Broadcom expressly reserves all rights in and to the
* Software and all intellectual property rights therein. IF YOU HAVE NO
* AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY
* WAY, AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL USE OF
* THE SOFTWARE.
"""

# Recommend Python version 2.5.x: http://www.activestate.com/activepython/downloads

import sys

def rflog(fname):
    f = file(fname)
    lines = f.readlines()
    f.close()
    signal_strengh = []
    ref_clock_offset = []
    INDEX_MESSAGEG_NAME     = 2
    INDEX_SIGNAL_STRENGTH   = 4
    INDEX_REF_CLOCK_OFFSET  = 0xC
    INDEX_RTC_CLOCK_OFFSET  = 0xE
    INDEX_CNTIN_STATUS      = 0xF
    INDEX_CNTIN_OFFSET      = 0x10
    tracking = False
    for l in lines:
        if ',FTS,' in l:
            fields = l[l.find('PGLOR'):].split(',')
##            print fields
            if fields[INDEX_MESSAGEG_NAME] != 'FTS':
                continue
            if not fields[INDEX_REF_CLOCK_OFFSET]:
                continue
            # Skip the first tracking
            if tracking:
                signal_strengh.append(float(fields[INDEX_SIGNAL_STRENGTH]))
                ref_clock_offset.append(float(fields[INDEX_REF_CLOCK_OFFSET]))
                length = len((fields[INDEX_RTC_CLOCK_OFFSET]))
                if length:
                    rtc_clock_offset = float(fields[INDEX_RTC_CLOCK_OFFSET])
                
                continue
            tracking = True
            cntin_status = fields[INDEX_CNTIN_STATUS]
            cntin_offset = fields[INDEX_CNTIN_OFFSET]

    signal_strength_average = sum(signal_strengh) / len(signal_strengh)
    ref_clock_offset_average = sum(ref_clock_offset) / len(ref_clock_offset)
    
    if signal_strength_average > -130.5:
        status = 'PASS'
    else:
        status = 'FAIL'
    print 'Data points = %d' % (len(signal_strengh))
    print 'Average Signal Strength = %0.2f dBm, %s' % (signal_strength_average, status)
    print 'Average TCXO offset = %0.2f ppb' % (ref_clock_offset_average)
    print 'CNTIN status = %s, offset = %s ppb' % (cntin_status, cntin_offset)
    print 'RTC clock offset = %0.2f ppm' % (rtc_clock_offset)
    
def usage():
    print 'Utility to analyze the log file of RF test results'
    print 'Example:\n'
    print '\t%s gl-Factory_High_SNR_x.txt' % (sys.argv[0])
    
if __name__ == '__main__':
    try:
        rflog(sys.argv[1])
    except:
        usage()