@echo off
REM * Copyright 2013 Broadcom Corporation -- http://www.broadcom.com
REM * This program is the proprietary software of Broadcom Corporation and/or
REM * its licensors, and may only be used, duplicated, modified or distributed
REM * pursuant to the terms and conditions of a separate, written license
REM * agreement executed between you and Broadcom (an "Authorized License").
REM * Except as set forth in an Authorized License, Broadcom grants no license
REM * (express or implied), right to use, or waiver of any kind with respect to
REM * the Software, and Broadcom expressly reserves all rights in and to the
REM * Software and all intellectual property rights therein. IF YOU HAVE NO
REM * AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY
REM * WAY, AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL USE OF
REM * THE SOFTWARE.

setlocal
bcdedit -debug on > nul || goto MUST_BE_ADMIN

set hostip=%1
set port=%2
set busparams=%3

if "%hostip%" == "" goto USAGE
if "%port%" == "" goto USAGE
if "%busparams%" == "" goto USAGE

bcdedit /dbgsettings net hostip:%hostip% port:%port% > nul || goto USAGE
bcdedit /set {dbgsettings} busparams %busparams% > nul || goto USAGE

goto REBOOT

:USAGE
echo Support network cards
echo     http://msdn.microsoft.com/en-us/library/windows/hardware/hh830880
echo.
echo Usage: %0 hostip port busparams
echo.
echo Where:
echo    hostip - IP address of host computer running WinDbg. Not this computer.
echo.
echo    port   - Port number, typically starting from 50000
echo           If your host connects to multiple targets, port number 
echo           must be unique for each target
echo.
echo    busparams - Device Manager\Network adaptors\<LAN>\Properties\General\Location b.d.f
echo           b - Bus numer
echo           d - Device number
echo           f - Function number
echo.
echo Example: %0 10.21.82.134 50001 0.25.0
echo.
goto FINISH

:REBOOT
for /f %%h in ('hostname') do (
    set connection=Windbg_Net_%%h.txt
)

bcdedit /dbgsettings > %connection%
echo ==========================================================================
echo Host machine connection information in %connection%
echo Copy this file %connection% to host computer before rebooting
echo --------------------------------------------------------------------------
type %connection%
echo --------------------------------------------------------------------------

echo.
echo It is recommended to run AppverifOn.bat before rebooting
echo.
echo Root computer for settings to take effect
goto FINISH

:USER_ERROR
echo.
echo Run as administrator might help

:FINISH
pause
endlocal