@echo off
REM * Copyright 2013 Broadcom Corporation -- http://www.broadcom.com
REM * This program is the proprietary software of Broadcom Corporation and/or
REM * its licensors, and may only be used, duplicated, modified or distributed
REM * pursuant to the terms and conditions of a separate, written license
REM * agreement executed between you and Broadcom (an "Authorized License").
REM * Except as set forth in an Authorized License, Broadcom grants no license
REM * (express or implied), right to use, or waiver of any kind with respect to
REM * the Software, and Broadcom expressly reserves all rights in and to the
REM * Software and all intellectual property rights therein. IF YOU HAVE NO
REM * AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY
REM * WAY, AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL USE OF
REM * THE SOFTWARE.

setlocal

REM ************** ParseParams start **************

set CDIR=%~dp0
echo CDIR: %CDIR%
set LogMinimal=NO


:ParseParams
set Parameter=%~1

if '%Parameter%' neq '' (
    set Parameter=%Parameter:"=%
)

if /i "%Parameter%" == "" goto ExitParseParams

if /i "%Parameter:~0,12%" == "-LOG_MINIMAL" (
set LogMinimal=YES
)

if /i "%Parameter:~0,12%" == "/LOG_MINIMAL" (
set LogMinimal=YES
)

shift
goto ParseParams
:ExitParseParams

set TRACE_FLAGS=0xFFFF
set TRACE_LEVEL=0xFFFFFFFFFFFFFFFF

if "%LogMinimal%" == "YES" (
set TRACE_FLAGS=0xFFFD
set TRACE_LEVEL=0xF
)

@echo off
set DEVCON_EXE="%CDIR%..\..\Tools\devcon.exe"
if EXIST %DEVCON_EXE% goto DEVCON_FOUND
echo %DEVCON_EXE% not found!

set DEVCON_EXE="%CDIR%devcon.exe"
if EXIST %DEVCON_EXE% goto DEVCON_FOUND
echo %DEVCON_EXE% not found!

set DEVCON_EXE="%SystemRoot%\System32\devcon.exe"
if EXIST %DEVCON_EXE% goto DEVCON_FOUND
echo %DEVCON_EXE% not found!

set DEVCON_EXE="%SystemRoot%\devcon.exe"
if EXIST %DEVCON_EXE% goto DEVCON_FOUND
echo %DEVCON_EXE% not found!

echo.
echo Error: Unable to locate devcon.exe
echo.
goto FINISH

:DEVCON_FOUND

call "%CDIR%TraceSetLoggerName.bat"

echo.
echo LogMinimal         : %LogMinimal%
echo LOGGER_NAME        : %LOGGER_NAME%
echo TRACE_FLAGS        : %TRACE_FLAGS%
echo TRACE_LEVEL        : %TRACE_LEVEL%
echo DEVCON_EXE         : %DEVCON_EXE%
echo.

REM ************** End ParseParams **************

REM Enable "trace configuration" for Location driver and GNSS engine
reg import "%CDIR%..\LogTrace.reg"

echo Saving and moving old log files to OLDLocationLogs
pushd "%CDIR%"
if NOT EXIST OLDLocationLogs md OLDLocationLogs
copy /Y location*.* .\OLDLocationLogs\*
del /Q /F location*.*
echo Done - Saving and moving old log files
popd

REM Disable location driver
echo.
echo %DEVCON_EXE% disable "Sensors\BcmGnssLocationSensor*"
%DEVCON_EXE% disable "Sensors\BcmGnssLocationSensor*" 

REM Start trace
echo.
echo tracelog.exe -start %LOGGER_NAME% -guid "%CDIR%TraceGuid.txt" -f "%CDIR%%LOGGER_NAME%.etl" -ft 5 -flag %TRACE_FLAGS% -level %TRACE_LEVEL%
tracelog.exe -start %LOGGER_NAME% -guid "%CDIR%TraceGuid.txt" -f "%CDIR%%LOGGER_NAME%.etl" -ft 5 -flag %TRACE_FLAGS% -level %TRACE_LEVEL% || goto USER_ERROR

REM Enable location driver for "trace configuration" to take effect
echo.
echo %DEVCON_EXE% enable "Sensors\BcmGnssLocationSensor*"
%DEVCON_EXE% enable "Sensors\BcmGnssLocationSensor*" 

REM Configure the pdb files for running TraceOut.bat in future
call "%CDIR%TracePdb.bat"

goto FINISH

:USER_ERROR
echo.
@echo  
echo ======================== SUGGESTIONS ========================
echo Ensure tracelog.exe from Windows Kits is copied to %SystemRoot%\
echo Run as administrator might also help
echo Otherwise, the trace session ^"%LOGGER_NAME%^" was already started
echo ======================== SUGGESTIONS ========================
pause

:FINISH

endlocal
