@echo off
REM * Copyright 2012 Broadcom Corporation -- http://www.broadcom.com
REM * This program is the proprietary software of Broadcom Corporation and/or
REM * its licensors, and may only be used, duplicated, modified or distributed
REM * pursuant to the terms and conditions of a separate, written license
REM * agreement executed between you and Broadcom (an "Authorized License").
REM * Except as set forth in an Authorized License, Broadcom grants no license
REM * (express or implied), right to use, or waiver of any kind with respect to
REM * the Software, and Broadcom expressly reserves all rights in and to the
REM * Software and all intellectual property rights therein. IF YOU HAVE NO
REM * AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY
REM * WAY, AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL USE OF
REM * THE SOFTWARE.
setlocal EnableDelayedExpansion
REM mode con: cols=100

REM Take first parameter
set LogDir=%1

REM Validate first parameter
if defined LogDir goto READY

REM Default to latest log directory
set LogDir=%ProgramData%\Broadcom\Location
if exist %LogDir% goto READY

REM Default to old log directory
set LogDir=C:\BcmGnssLog

:READY
if defined Check_Signal_Reception goto CHECK_SIGNAL_RECEPTION

if defined Check_Position_Report goto CHECK_POSITION_REPORT

REM Need to have some directory to work on
if not exist %LogDir% goto NEED_PRESENCE_OF_LOG_DIR

set CurrentTime=%time::=.%
set CurrentTime=%CurrentTime: =0%
set ProcessedLogs=%~dp0ProcessedLogs_%date:~10,4%.%date:~4,2%.%date:~7,2%_%CurrentTime%
mkdir %ProcessedLogs%
if exist %~dp0errors.txt del /F /Q %~dp0errors.txt || goto DEBUG_ERROR_FILE

:DETECT_SERIAL_ERROR
pushd %LogDir%
if defined SKIP_BANNER goto SKIP_BANNER
echo.
echo ============================Serial Test Summary============================
echo %date% %time%
echo Validating files in %cd% 
REM dir /B /ODN gl-*.txt
echo ---------------------------------------------------------------------------
:SKIP_BANNER
REM echo Generate a list of files by gl*.txt
set FileList=
for /f %%f in ('dir /B /ODN gl-*.txt') do (
    if defined FileList (
        set FileList=!FileList! %%f
    ) else (
        set FileList=%%f
    )
    set LatestFile=%%f
)

if "%FileList%" == "" goto FINISH

if "%LatestFileShown%" NEQ "%LatestFile%" (
    echo %date% %time%
    set LatestFileShown=
    set LatestFile
    set LatestFileShown=%LatestFile%
)

REM echo Process all files except the last one
REM set FileList
REM set LatestFile
for %%f in (%FileList%) do (
    if "%%f" NEQ "%LatestFile%" (
        echo Processing %%f
        call:DETECT_ERROR_IN_FILE_FUNCTION %%f moveFile
    )
)

if not defined OFFLINE_CHECK goto DETECT_SERIAL_ERROR_END
set moveFile=moveFile

echo Validate last file
if "%FileList%" == "%LatestFile%" (
    echo Processing %LatestFile%
    call:DETECT_ERROR_IN_FILE_FUNCTION %LatestFile% %moveFile%
    if defined OFFLINE_CHECK set OFFLINE_CHECK=
)

:DETECT_SERIAL_ERROR_END
popd

if defined REPEAT_CHECK (
    set SKIP_BANNER=true
    goto DETECT_SERIAL_ERROR
)

if defined OFFLINE_CHECK (
    set SKIP_BANNER=true
    goto DETECT_SERIAL_ERROR
)

:NO_ERRORS_AS_IT_APPEARS
echo.
echo ==============================Congratulations==============================
echo.
echo No Errors Detected. Do a manual validation to ensure no errors indeed!
echo.
echo ==============================Congratulations==============================
if exist %~dp0errors.txt del /F /Q %~dp0errors.txt || goto DEBUG_ERROR_FILE
if exist %~dp0summary.txt del /F /Q %~dp0summary.txt || goto DEBUG_SUMMARY_FILE
goto FINISH

if defined REPEAT_CHECK goto DETECT_SERIAL_ERROR
call:DETECT_ERROR_FUNCTION

:NEED_PRESENCE_OF_LOG_DIR
echo ===============================Invalid Input===============================
echo Must pass the BcmGnss log directory as first parameter
echo Example: %ProgramData%\Broadcom\Location
echo The best way is to drag the directory onto this script file
goto FINISH

:DEBUG_ERROR_FILE
echo ===============================Invalid File================================
echo Use http://technet.microsoft.com/en-US/sysinternals procexp.exe to analyze
echo why %~dp0errors.txt cannot be deleted
goto FINISH

:DEBUG_SUMMARY_FILE
echo ===============================Invalid File================================
echo Use http://technet.microsoft.com/en-US/sysinternals procexp.exe to analyze
echo why %~dp0summary.txt cannot be deleted
goto FINISH

:CHECK_SIGNAL_RECEPTION
pushd %LogDir%
findstr /C:"GSV," gl*.txt
popd
echo ---------------------------------------------------------------------------
echo See UserManual\index.html to decode the signal strength from *GSV lines
echo Other online reference: http://www.gpsinformation.org/dale/nmea.htm#GSV
echo ---------------------------------------------------------------------------
goto FINISH

:CHECK_POSITION_REPORT
pushd %LogDir%
findstr /C:",FIX," gl*.txt
popd
goto FINISH

:DETECT_ERROR_IN_FILE_FUNCTION
echo.
echo ===========================================================================
echo Validating file: %~1
echo ---------------------------------------------------------------------------
echo Validating absence of "SetDeathCause"
findstr /S /C:"SetDeathCause" %~1 >> %~dp0errors.txt
call:DETECT_ERROR_FUNCTION

echo Validating absence of "Abnormal GlEngine"
findstr /S /C:"Abnormal GlEngine" %~1 >> %~dp0errors.txt
call:DETECT_ERROR_FUNCTION

echo Validating absence of "SIO:RxERR: Sequence error"
findstr /S /C:"SIO:RxERR: Sequence error" %~1 >> %~dp0errors.txt
call:DETECT_ERROR_FUNCTION

echo Validating absence of "SIO:RxERR: CRC"
findstr /S /C:"SIO:RxERR: CRC" %~1 >> %~dp0errors.txt
call:DETECT_ERROR_FUNCTION

echo Validating absence of "dwErr:"
findstr /S /C:"dwErr:" %~1 >> %~dp0errors.txt
call:DETECT_ERROR_FUNCTION

echo Validating absence of "SIO:RxERR MF packet"
findstr /S /C:"SIO:RxERR MF packet" %~1 >> %~dp0errors.txt
call:DETECT_ERROR_FUNCTION

echo Validating lines with "SIO,TxERR" only contain "SIO,TxERR,0,RxERR,0"
findstr /S /C:"SIO,TxERR" %~1 | find /v "SIO,TxERR,0,RxERR,0" >> %~dp0errors.txt
call:DETECT_ERROR_FUNCTION

::echo ---------------------------------------------------------------------------
::echo Collecting "Serial Tx" in job summary
findstr /S /C:"Serial Tx" %~1 > %~dp0summary.txt

::echo Searching for errors in job summary
echo Validating lines with "Serial Tx" only contain "0 Seq errors"
type %~dp0summary.txt | find /v "0 Seq errors" >> %~dp0errors.txt
call:DETECT_ERROR_FUNCTION

echo Validating lines with "Serial Tx" only contain "0 CRC errors"
type %~dp0summary.txt | find /v "0 CRC errors" >> %~dp0errors.txt
call:DETECT_ERROR_FUNCTION

::echo ---------------------------------------------------------------------------
::echo Collecting "Serial Rx" in job summary
findstr /S /C:"Serial Rx" %~1  > %~dp0summary.txt

echo Validating lines with "Serial Rx" only contain "0 Seq errors"
type %~dp0summary.txt | find /v "0 Seq errors" >> %~dp0errors.txt
call:DETECT_ERROR_FUNCTION

echo Validating lines with "Serial Rx" only contain "0 CRC errors"
type %~dp0summary.txt | find /v "0 CRC errors" >> %~dp0errors.txt
call:DETECT_ERROR_FUNCTION

echo Validating lines with "Serial Rx" only contain "0 Malformed Pckts"
type %~dp0summary.txt | find /v "0 Malformed Pckts" >> %~dp0errors.txt
call:DETECT_ERROR_FUNCTION

if "%~2" == "moveFile" (
    echo No errors found in %~1
    echo Moving %~1 to %ProcessedLogs%\
    move /Y %~1 %ProcessedLogs%\ || goto ERROR_HANLDER
    REM Alternatively, delete the file if disk space runs out quickly
    REM del /Q %~1 || goto ERROR_HANLDER
)
:DETECT_ERROR_IN_FILE_FUNCTION_END
goto:EOF

:DETECT_ERROR_FUNCTION
for /F %%a in (%~dp0errors.txt) do (
    @echo  
    echo =============================Error Lines Begin=============================
    type %~dp0errors.txt
    echo ==============================Error Lines End==============================
    echo Error summary is in file: %~dp0errors.txt
    echo Manually validate these are indeed errors!
    echo Ctrl-C to stop beeping
    taskkill /f /im rundll32.exe 2> nul
    ping 127.0.0.0 -n 3 > nul
)
goto:EOF


:ERROR_HANLDER
echo ========================================================
echo Running as administrator might help!
echo ========================================================
pause

:FINISH
if defined ProcessedLogs (
    echo Processed log files are moved to %ProcessedLogs%
)
endlocal
pause