#! /usr/bin/python
"""
* Copyright 2001-2013 Broadcom Corporation -- http://www.broadcom.com
* This program is the proprietary software of Broadcom Corporation and/or
* its licensors, and may only be used, duplicated, modified or distributed
* pursuant to the terms and conditions of a separate, written license
* agreement executed between you and Broadcom (an "Authorized License").
* Except as set forth in an Authorized License, Broadcom grants no license
* (express or implied), right to use, or waiver of any kind with respect to
* the Software, and Broadcom expressly reserves all rights in and to the
* Software and all intellectual property rights therein. IF YOU HAVE NO
* AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY
* WAY, AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL USE OF
* THE SOFTWARE.
"""

'''
Usage examples:
python SerialLog.py ha.txt ":H->A"
python SerialLog.py ah.txt ":H<-A"
python SerialLog.py gl-log.txt " H->A" REM This will create a file of host to ASIC packets
python SerialLog.py gl-log.txt " H<-A" REM This will create a file of ASIC to host packets
'''
import sys

crc_table = \
[
    0x00,0x4d,0x9a,0xd7,0x79,0x34,0xe3,0xae,0xf2,0xbf,0x68,0x25,0x8b,0xc6,0x11,0x5c,
    0xa9,0xe4,0x33,0x7e,0xd0,0x9d,0x4a,0x07,0x5b,0x16,0xc1,0x8c,0x22,0x6f,0xb8,0xf5,
    0x1f,0x52,0x85,0xc8,0x66,0x2b,0xfc,0xb1,0xed,0xa0,0x77,0x3a,0x94,0xd9,0x0e,0x43,
    0xb6,0xfb,0x2c,0x61,0xcf,0x82,0x55,0x18,0x44,0x09,0xde,0x93,0x3d,0x70,0xa7,0xea,
    0x3e,0x73,0xa4,0xe9,0x47,0x0a,0xdd,0x90,0xcc,0x81,0x56,0x1b,0xb5,0xf8,0x2f,0x62,
    0x97,0xda,0x0d,0x40,0xee,0xa3,0x74,0x39,0x65,0x28,0xff,0xb2,0x1c,0x51,0x86,0xcb,
    0x21,0x6c,0xbb,0xf6,0x58,0x15,0xc2,0x8f,0xd3,0x9e,0x49,0x04,0xaa,0xe7,0x30,0x7d,
    0x88,0xc5,0x12,0x5f,0xf1,0xbc,0x6b,0x26,0x7a,0x37,0xe0,0xad,0x03,0x4e,0x99,0xd4,
    0x7c,0x31,0xe6,0xab,0x05,0x48,0x9f,0xd2,0x8e,0xc3,0x14,0x59,0xf7,0xba,0x6d,0x20,
    0xd5,0x98,0x4f,0x02,0xac,0xe1,0x36,0x7b,0x27,0x6a,0xbd,0xf0,0x5e,0x13,0xc4,0x89,
    0x63,0x2e,0xf9,0xb4,0x1a,0x57,0x80,0xcd,0x91,0xdc,0x0b,0x46,0xe8,0xa5,0x72,0x3f,
    0xca,0x87,0x50,0x1d,0xb3,0xfe,0x29,0x64,0x38,0x75,0xa2,0xef,0x41,0x0c,0xdb,0x96,
    0x42,0x0f,0xd8,0x95,0x3b,0x76,0xa1,0xec,0xb0,0xfd,0x2a,0x67,0xc9,0x84,0x53,0x1e,
    0xeb,0xa6,0x71,0x3c,0x92,0xdf,0x08,0x45,0x19,0x54,0x83,0xce,0x60,0x2d,0xfa,0xb7,
    0x5d,0x10,0xc7,0x8a,0x24,0x69,0xbe,0xf3,0xaf,0xe2,0x35,0x78,0xd6,0x9b,0x4c,0x01,
    0xf4,0xb9,0x6e,0x23,0x8d,0xc0,0x17,0x5a,0x06,0x4b,0x9c,0xd1,0x7f,0x32,0xe5,0xa8
]

def compute_crc(line):
    crc = 0
    global crc_table
    packet = line.split()
##    print packet[2:-2]
    escape = False
    for i in packet[2:-3]:
        if escape:
            escape = False
            if i == '04':
                i = '13'
            elif i == '03':
                i = '11'
            elif i == '02':
                i = 'E0'
        if i.upper() == 'E0':
            escape = True
            continue
        crc = 0xFF & crc_table[crc ^ int(i, 16)]
    return ((crc & 0xF) << 4) | ((crc & 0xF0) >> 4)

def packetize(lines, fd):
    header_ha = '80 80 80 80 80 80 80 80 80 80 80 80 80 80 80 80 FE'
    header_ha_new='\n80 80 80 80 80 80 80 80 80 80 80 80 80 80 80 80\nFE'
    header_ah = '00 FE 00 FD'
    header_ah_new = '00\nFE 00 FD'
    
    # Python style - it's cheaper to create memory than replace
    a = lines.replace(header_ha, header_ha_new)
    b = a.replace(header_ah, header_ah_new)
    c = b.replace('FC FE', 'FC\nFE')
    d = c.replace('E0 01 E0 00', 'E0 01\nE0 00')
    e = d.replace('FC E0 00', 'FC\nE0 00')
    f = e.replace('FC FF 00 FD', 'FC\nFF 00 FD')
        
    fd.write(f)
    
def refine(fname, token=' H<-A', sardine_mode = True):
    f = file(fname)
    data = []
    for l in f.readlines():
        index = l.find(token)
        if index > 0:
            data.append(l[index + len(token):].strip())
    # Write the raw data to a new file
    fname_raw = fname + '_raw.txt'
    f = file(fname_raw, 'w')
    f.write('\n'.join(data))
    f.close()
    print 'Created', fname_raw
    
    # Write the packetize data to a new file
    fname_packet = fname + '_packets.txt'
    f = file(fname_packet, 'w')
    lines = ' '.join(data)
    if sardine_mode: # BCM4752 or newer
        packetize(lines, f)
    else: # BCM47511 or older
        f.write(lines.replace('FC FE', 'FC\nFE'))
    f.close()
    print 'Created', fname_packet

if __name__ == '__main__':
    fname = sys.argv[1]
    token = sys.argv[2]
    sardine_mode = True
    if len(sys.argv) > 3 and (sys.argv[3] == '-b' or sys.argv[3] == '--barracuda'):
        sardine_mode = False
    refine(fname, token, sardine_mode)