@echo off
REM * Copyright 2012, 2013 Broadcom Corporation -- http://www.broadcom.com
REM * This program is the proprietary software of Broadcom Corporation and/or
REM * its licensors, and may only be used, duplicated, modified or distributed
REM * pursuant to the terms and conditions of a separate, written license
REM * agreement executed between you and Broadcom (an "Authorized License").
REM * Except as set forth in an Authorized License, Broadcom grants no license
REM * (express or implied), right to use, or waiver of any kind with respect to
REM * the Software, and Broadcom expressly reserves all rights in and to the
REM * Software and all intellectual property rights therein. IF YOU HAVE NO
REM * AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY
REM * WAY, AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL USE OF
REM * THE SOFTWARE.

"%~dp0..\..\Tools\devcon.exe" rescan > nul || (
    goto MUST_BE_ADMIN
)

if not exist %~dp0..\..\Tools\SensorDiagnosticTool.exe goto MUST_HAVE_SDT

echo Validate repeatedly client can open/close and sensor can disable/enable
echo Ensure traceview is setup to capture into a log file
pause

set /a repetition=0
:AGAIN
echo.
set /a repetition=%repetition%+1
echo %date% %time%: repetition %repetition% 

"%~dp0..\..\Tools\devcon.exe" disable "Sensors\BcmGnssLocationSensor*" 

ping 1.1.1.1 -n 2 -w 1000 > nul

"%~dp0..\..\Tools\devcon.exe" enable "Sensors\BcmGnssLocationSensor*" 

set /a x=%random% %% 2
if "%x%"=="0" goto START_SDT
echo Delaying %x% second to launch SDT
ping 1.1.1.1 -n %x% -w 1000 > nul

:START_SDT
start %~dp0..\..\Tools\SensorDiagnosticTool.exe

set /a x=%random% %% 8

if "%x%"=="0" goto KEEP_SDT
set /a y=x+2
echo Closing SDT in %y% seconds...
ping 1.1.1.1 -n %y% -w 1000 > nul

taskkill /f /im SensorDiagnosticTool.exe > nul
ping 1.1.1.1 -n 1 -w 1000 > nul

goto AGAIN

:KEEP_SDT
echo Keeping SDT open
goto AGAIN

:MUST_BE_ADMIN
echo ================================= Error ==================================
echo Must run as Administrator
goto FINISH

:MUST_HAVE_SDT
echo ================================= Error ==================================
echo Must have %~dp0..\..\Tools\SensorDiagnosticTool.exe
echo Get from http://msdn.microsoft.com/en-us/library/windows/hardware/ff547083(v=vs.85).aspx#tech_sensors
goto FINISH

:FINISH
pause
