@echo off
REM * Copyright 2012 Broadcom Corporation -- http://www.broadcom.com
REM * This program is the proprietary software of Broadcom Corporation and/or
REM * its licensors, and may only be used, duplicated, modified or distributed
REM * pursuant to the terms and conditions of a separate, written license
REM * agreement executed between you and Broadcom (an "Authorized License").
REM * Except as set forth in an Authorized License, Broadcom grants no license
REM * (express or implied), right to use, or waiver of any kind with respect to
REM * the Software, and Broadcom expressly reserves all rights in and to the
REM * Software and all intellectual property rights therein. IF YOU HAVE NO
REM * AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY
REM * WAY, AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL USE OF
REM * THE SOFTWARE.

if not exist OS_Type.txt goto DETERMINE_OS_TYPE_BY_SYSTEM_INFO
:DETERMINE_OS_TYPE_BY_FILE_CREATED
echo Determine OS type by file created
for /f %%o in (OS_Type.txt) do (set OS_Type=%%o)
goto VALIDATE_OS_TYPE

:DETERMINE_OS_TYPE_BY_SYSTEM_INFO
echo Determine OS type by systeminfo
for /f "tokens=3 delims= " %%t in ('systeminfo ^| findstr /C:"System Type"') do (
    set SystemType=%%t
)
set OS_Type=
if "%SystemType%" == "X86-based" (set OS_Type=Win32)
if "%SystemType%" == "x64-based" (set OS_Type=x64)
if "%SystemType%" == "WoA-based" (set OS_Type=ARM)

:VALIDATE_OS_TYPE
if not defined OS_Type goto UNKNOWN_OS_Type
set OS_Type
echo %OS_Type% > OS_Type.txt
goto FINISH

:UNKNOWN_OS_Type
echo -----------------------------------ERROR-----------------------------------
echo Unable to determine Operating System Type
pause
goto FINISH

:FINISH

