@echo off
REM * Copyright 2012, 2013 Broadcom Corporation -- http://www.broadcom.com
REM * This program is the proprietary software of Broadcom Corporation and/or
REM * its licensors, and may only be used, duplicated, modified or distributed
REM * pursuant to the terms and conditions of a separate, written license
REM * agreement executed between you and Broadcom (an "Authorized License").
REM * Except as set forth in an Authorized License, Broadcom grants no license
REM * (express or implied), right to use, or waiver of any kind with respect to
REM * the Software, and Broadcom expressly reserves all rights in and to the
REM * Software and all intellectual property rights therein. IF YOU HAVE NO
REM * AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY
REM * WAY, AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL USE OF
REM * THE SOFTWARE.
setlocal

"%~dp0..\Tools\devcon.exe" rescan > nul || (
    goto MUST_BE_ADMIN
)

set LogDir=%ProgramData%\Broadcom\Location
set DriverDir=%SystemRoot%\System32\Drivers\UMDF
set CoreLibrary=BcmGnss.dll
if not exist %DriverDir%\%CoreLibrary% goto MUST_HAVE_SENSOR_INSTALLED

set job=%1
if "%job%" == "" set job=CollectAlmanac
echo ==========================================================================
echo WARNING - DO NOT INTERRUPT THIS TEST AND LET IT TERMINATE NATURALLY
echo --------------------------------------------------------------------------
echo.
echo Running job %job%
echo.

set KnownJobs=Bringup
set KnownJobs=%KnownJobs% Serial_Stress_Need_Satellites
set KnownJobs=%KnownJobs% Serial_Stress_No_Satellites
set KnownJobs=%KnownJobs% CollectAlmanac
set KnownJobs=%KnownJobs% Hot_Starts
set KnownJobs=%KnownJobs% Lost_Starts
set KnownJobs=%KnownJobs% Far_Starts
set KnownJobs=%KnownJobs% Warm_Starts
set KnownJobs=%KnownJobs% Cold_Starts
set KnownJobs=%KnownJobs% Factory_GNSS_Track_Test
set KnownJobs=%KnownJobs% Factory_GPS_CW_Test
set KnownJobs=%KnownJobs% Factory_GLONASS_CW_Test
set KnownJobs=%KnownJobs% Factory_Low_SNR

REM This is superceded by Factory_GNSS_Track_Test or Factory_GPS_Track_Test
set KnownJobs=%KnownJobs% Factory_High_SNR

set found=false

for %%j in (%KnownJobs%) do (
    if %%j == %job% set found=true
)

if "%found%" NEQ "true" (
    goto UNDESCRIBED_JOB
)

goto %job%

:Bringup
echo This job ensures the basic hardware and drivers are functioning properly.
echo --------------------------------------------------------------------------
echo This test typically takes approximately 30 seconds indoor or open-sky.
reg import "%~dp0LogRawByteStreamOn.reg" 2> nul
goto RUN_JOB

:Serial_Stress_Need_Satellites
echo This job typically ensures the hardware and UART/GPIO drivers are robust.
echo.
echo Ensure DUT is exposed to GNSS satellites
echo --------------------------------------------------------------------------
echo This test typically takes approximately 24 hours under open-sky.
reg import "%~dp0LogRawByteStreamOn.reg" 2> nul
goto RUN_JOB

:Serial_Stress_No_Satellites
echo This job typically ensures the hardware and UART/GPIO drivers are robust.
echo.
echo Ensure DUT is NOT exposed to GNSS satellites
echo --------------------------------------------------------------------------
echo This test typically takes approximately 24 hours under open-sky.
reg import "%~dp0LogRawByteStreamOn.reg" 2> nul
goto RUN_JOB

:CollectAlmanac
echo This job typically measures the general RF performance of the platform.
echo It collects satellite almanac, ephemeris, reference time, reference
echo position, etc.
echo.
echo Satellite signals live or simulated are required.
echo It is necessary to perform this step before running systematic tests
echo such as Hot_Starts, Warm_Starts, Cold_Starts etc.
echo --------------------------------------------------------------------------
echo This test typically takes approximately 15 minutes under open-sky.
goto RUN_JOB

:Hot_Starts
echo This job typically measures the time required for location device to
echo compute the first position with the existence of the following data:
echo 1. Live Ephemeris
echo 2. Reference Time
echo 3. Reference Position
echo.
echo Satellite signals live or simulated are required.
echo To ensure accurate measurements, run CollectAlmanac before running this.
echo --------------------------------------------------------------------------
echo This test typically takes approximately 5 minutes under open-sky.
goto RUN_JOB

:Lost_Starts
echo This job typically measures the time required for location device to
echo compute the first position with the existence of the following data:
echo 1. Live Ephemeris
echo 2. Reference Time
echo 3. Reference Position is unavailable
echo.
echo Satellite signals live or simulated are required.
echo To ensure accurate measurements, run CollectAlmanac before running this.
echo --------------------------------------------------------------------------
echo This test typically takes approximately 5 minutes under open-sky.
goto RUN_JOB

:Far_Starts
echo This job typically measures the time required for location device to
echo compute the first position with the existence of the following data:
echo 1. Live Ephemeris
echo 2. Reference Time
echo 3. Reference Position is incorrect
echo.
echo Satellite signals live or simulated are required.
echo To ensure accurate measurements, run CollectAlmanac before running this.
echo --------------------------------------------------------------------------
echo This test typically takes approximately 5 minutes under open-sky.
goto RUN_JOB

:Warm_Starts
echo This job typically measures the time required for location device to
echo compute the first position in the absence of the following data:
echo 1. Live Ephemeris
echo.
echo Satellite signals live or simulated are required.
echo --------------------------------------------------------------------------
echo This test typically takes approximately 50 minutes under open-sky, no LTO.
echo This test typically takes approximately 5 minutes under open-sky, with LTO.
goto RUN_JOB

:Cold_Starts
echo This job typically measures the time required for location device to
echo compute the first position in the absence of the following data:
echo 1. Live Ephemeris
echo 2. Reference Time
echo 3. Reference Position
echo.
echo Satellite signals live or simulated are required.
echo --------------------------------------------------------------------------
echo This test typically takes approximately 60 minutes under open-sky.
goto RUN_JOB

:Factory_GNSS_Track_Test
echo This job is typically for production factory assembly line, measuring the
echo RF characteristics of each individual product item.
echo.
echo A single channel simulator is required.
echo --------------------------------------------------------------------------
echo This test typically takes approximately 2 minutes.
goto RUN_JOB

:Factory_GPS_CW_Test
echo This job is typically for production factory assembly line, measuring the
echo RF characteristics of each individual product item.
echo.
echo A single channel simulator is required.
echo --------------------------------------------------------------------------
echo This test typically takes approximately 2 minutes.
goto RUN_JOB

:Factory_GLONASS_CW_Test
echo This job is typically for production factory assembly line, measuring the
echo RF characteristics of each individual product item.
echo.
echo A single channel simulator is required.
echo --------------------------------------------------------------------------
echo This test typically takes approximately 2 minutes.
goto RUN_JOB

:Factory_Low_SNR
echo This job is typically for production factory assembly line, measuring the
echo RF characteristics of each individual product item.
echo.
echo A single channel simulator is required.
echo --------------------------------------------------------------------------
echo This test typically takes approximately 30 seconds.
goto RUN_JOB

:Factory_High_SNR
echo This job is typically for production factory assembly line, measuring the
echo RF characteristics of each individual product item.
echo.
echo A single channel simulator is required.
echo --------------------------------------------------------------------------
echo This test typically takes approximately 30 seconds.
goto RUN_JOB

:UNDESCRIBED_JOB
echo See job description in BcmGnssConfig.xml

:RUN_JOB

reg import "%~dp0LogOn.reg" 2> nul
reg import "%~dp0NetworkIoOn.reg" 2> nul
if "%LogBasic%"=="" goto SHOW_WARNING
reg import "%~dp0LOG_Basic.reg" 2> nul

:SHOW_WARNING
echo ==========================================================================
echo WARNING - DO NOT INTERRUPT THIS TEST AND LET IT TERMINATE NATURALLY
echo --------------------------------------------------------------------------
echo If you really need to terminate, close this console windows and kill the
echo process "rundll32" that created %CoreLibrary%
echo.
pause
"%~dp0..\Tools\devcon.exe" disable "Sensors\BcmGnssLocationSensor*" > nul

if exist %LogDir%\SyslogArchive rd /Q /S %LogDir%\SyslogArchive
del /F /Q /S %LogDir%\*.txt 2> nul

pushd %DriverDir%
echo rundll32 %CoreLibrary% glgps_main BcmGnssConfig.xml %job%
rundll32 %CoreLibrary% glgps_main BcmGnssConfig.xml %job%
popd

reg import "%~dp0LOG_Default.reg" 2> nul
reg import "%~dp0LogOff.reg" 2> nul
reg import "%~dp0NetworkIoOff.reg" 2> nul

echo %DATE% %TIME%
if "%PauseWhenFinish%"=="" goto ENABLE_DRIVER
pause

:ENABLE_DRIVER
"%~dp0..\Tools\devcon.exe" enable "Sensors\BcmGnssLocationSensor*" > nul
echo ============================= Test Finished ==============================

goto FINISH

:MUST_BE_ADMIN
echo ================================= Error ==================================
echo Must run as Administrator
goto FINISH

:MUST_HAVE_SENSOR_INSTALLED
echo ================================= Error ==================================
echo "Sensors\BcmGnssLocationSensor*" must be completely installed successfully
goto FINISH

:FINISH
endlocal
pause