/*
 * Decompiled with CFR 0.152.
 */
package android_wifi_api;

import android.util.Log;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;

public class SocketSDK {
    private static final String LOG_TAG = "SNBC_SOCKET_SDK";
    public Socket socket = null;
    private SocketChannel socketChannel = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private DataOutputStream bufOutPutStream = null;
    private String dstName;
    private int dstPort;
    private boolean connectedToPos = false;
    private static final int POSPORT = 9100;
    private static final int STATEPORT = 4000;
    private static final int MAX_DATA_LENGTH = 4096;
    private static final int POSOKSTATE = 20;
    private byte[] posState = new byte[1];
    private boolean ThreadFlg = false;

    public SocketSDK(String dstName, int dstPort) {
        Log.d((String)LOG_TAG, (String)("constructor dstName: " + dstName + " dstPort: " + dstPort));
        this.dstName = dstName;
        this.dstPort = dstPort;
        this.createSocket(dstName, dstPort);
    }

    public boolean createSocket(String dstName, int dstPort) {
        try {
            if (dstPort == 9100) {
                this.socketChannel = this.openPortForwrite(dstName, dstPort, 3000);
                this.socket = this.socketChannel.socket();
            } else {
                this.socket = new Socket(dstName, dstPort);
            }
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
            this.bufOutPutStream = new DataOutputStream(this.outputStream);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"error in createSocket(String dstName, int dstPort) method");
            e.printStackTrace();
        }
        return this.connectedToPos;
    }

    public boolean isConnected() {
        try {
            if (!this.socket.isClosed() && this.socket.isConnected()) {
                this.connectedToPos = true;
                Log.e((String)LOG_TAG, (String)("Socket dstName: " + this.dstName + " dstPort: " + this.dstPort + "\u5904\u4e8e\u6d3b\u8dc3\u72b6\u6001"));
                new CheckSocketConnectionState().start();
            }
            return this.connectedToPos;
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"error in createSocket(String dstName, int dstPort) method");
            e.printStackTrace();
            return false;
        }
    }

    public boolean getConnectedToPos() {
        this.connectedToPos = this.socket != null && !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
        return this.connectedToPos;
    }

    public boolean clearSocket() {
        boolean result = true;
        try {
            if (this.dstPort == 9100) {
                this.writeSocketClose(this.socketChannel);
            }
            if (!this.socket.isOutputShutdown()) {
                this.outputStream.close();
                Log.e((String)LOG_TAG, (String)"Socket\u7684\u8f93\u51fa\u7f13\u51b2\u533a\u5df2\u5173\u3002");
            } else if (!this.socket.isInputShutdown()) {
                this.inputStream.close();
                Log.e((String)LOG_TAG, (String)"Socket\u7684\u8f93\u5165\u7f13\u51b2\u533a\u5df2\u5173\u3002");
            } else if (!this.socket.isClosed()) {
                this.socket.close();
                Log.e((String)LOG_TAG, (String)"Socket\u5df2\u5f7b\u5e95\u5173\u95ed\u3002");
            }
            Log.e((String)LOG_TAG, (String)"Socket\u6240\u5360\u7528\u7684\u8d44\u6e90\u5f97\u5230\u91ca\u653e\u3002");
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Socket\u6240\u5360\u7528\u7684\u90e8\u5206\u8d44\u6e90\u6ca1\u6709\u5f97\u5230\u91ca\u653e\u3002");
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    private SocketChannel openPortForwrite(String portName, int host, int timeout) {
        SocketChannel socket = null;
        boolean connectResult = false;
        InetSocketAddress sa = new InetSocketAddress(portName, host);
        try {
            socket = SocketChannel.open();
            socket.configureBlocking(false);
            Log.e((String)LOG_TAG, (String)("connect " + portName + " beginning"));
            connectResult = socket.connect(sa);
            Log.e((String)LOG_TAG, (String)("connect " + portName + " succeed"));
            if (!connectResult) {
                long tick = System.currentTimeMillis();
                long totulTick = tick + (long)timeout;
                while (totulTick > tick) {
                    if (socket.finishConnect()) break;
                    tick = System.currentTimeMillis();
                }
            }
            if (!socket.isConnected()) {
                this.writeSocketClose(socket);
                return null;
            }
        }
        catch (UnresolvedAddressException unresolvedAddressException) {
        }
        catch (UnsupportedAddressTypeException unsupportedAddressTypeException) {
        }
        catch (SecurityException securityException) {
        }
        catch (ClosedByInterruptException closedByInterruptException) {
        }
        catch (AsynchronousCloseException asynchronousCloseException) {
        }
        catch (AlreadyConnectedException alreadyConnectedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return socket;
    }

    private void writeSocketClose(SocketChannel socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.socket().shutdownInput();
            socket.socket().shutdownOutput();
            socket.close();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"\u5199Socket\u5173\u95ed\u53d1\u751f\u4f8b\u5916");
        }
        socket = null;
    }

    private boolean writeData(byte[] byteData, int length, int timeout) {
        ByteBuffer outputBuffer = ByteBuffer.allocate(length);
        outputBuffer.clear();
        outputBuffer.put(byteData);
        outputBuffer.rewind();
        try {
            long tick = System.currentTimeMillis();
            if (timeout < 5000) {
                timeout = 5000;
            }
            long totulTick = tick + (long)timeout;
            while (outputBuffer.hasRemaining()) {
                tick = System.currentTimeMillis();
                if (totulTick < tick) break;
                this.socketChannel.write(outputBuffer);
            }
            return !outputBuffer.hasRemaining();
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized boolean write(byte[] buffer) {
        boolean result = true;
        int bufLength = buffer.length;
        int sendtime = bufLength / 4096;
        int leftLength = 0;
        int sendPoint = 0;
        if (this.dstPort == 9100) {
            int timeout_ = 10000;
            int timeOutTimes = 1 + bufLength / 10240;
            return this.writeData(buffer, bufLength, timeout_ *= timeOutTimes);
        }
        if (this.getConnectedToPos() && this.outputStream != null) {
            if (sendtime == 0) {
                try {
                    this.bufOutPutStream.write(buffer);
                    this.bufOutPutStream.flush();
                }
                catch (Exception e) {
                    result = false;
                    Log.e((String)LOG_TAG, (String)"error in write method");
                    e.printStackTrace();
                }
            } else {
                leftLength = bufLength % 4096;
                int i = 0;
                while (i < sendtime) {
                    sendPoint = i * 4096;
                    try {
                        this.bufOutPutStream.write(buffer, sendPoint, 4096);
                        this.bufOutPutStream.flush();
                    }
                    catch (Exception e) {
                        result = false;
                        Log.e((String)LOG_TAG, (String)"error in write method");
                        e.printStackTrace();
                        return result;
                    }
                    ++i;
                }
                if (leftLength > 0) {
                    sendPoint += 4096;
                    try {
                        this.outputStream.write(buffer, sendPoint, leftLength);
                        this.bufOutPutStream.flush();
                    }
                    catch (Exception e) {
                        result = false;
                        Log.e((String)LOG_TAG, (String)"error in write method");
                        e.printStackTrace();
                        return result;
                    }
                }
            }
        } else {
            result = false;
            Log.e((String)LOG_TAG, (String)"\u5f53\u524dSocket\u5df2\u7ecf\u5173\u95ed\u6216\u8f93\u51fa\u7f13\u51b2\u533a\u4e0d\u5b58\u5728");
        }
        return result;
    }

    public synchronized int read(byte[] buffer) {
        int len = 0;
        if (this.getConnectedToPos() && this.inputStream != null) {
            try {
                len = this.inputStream.read(buffer);
            }
            catch (Exception e) {
                len = -1;
                Log.e((String)LOG_TAG, (String)"error in read method");
                e.printStackTrace();
            }
        } else {
            Log.e((String)LOG_TAG, (String)"\u5f53\u524dSocket\u5df2\u7ecf\u5173\u95ed\u6216\u8f93\u51fa\u7f13\u51b2\u533a\u4e0d\u5b58\u5728");
        }
        return len;
    }

    private static byte[] inputStreamToByte(InputStream inStream) throws Exception {
        int count = 0;
        int haveCheck = 0;
        while (count == 0) {
            count = inStream.available();
            if (++haveCheck < 50) continue;
            return null;
        }
        byte[] b = new byte[count];
        inStream.read(b);
        return b;
    }

    private class CheckSocketConnectionState
    extends Thread {
        private CheckSocketConnectionState() {
        }

        @Override
        public void run() {
            if (SocketSDK.this.dstPort == 4000) {
                Log.e((String)SocketSDK.LOG_TAG, (String)"Socket\u72b6\u6001\u76d1\u63a7\u7ebf\u7a0b\u542f\u52a8");
                while (SocketSDK.this.socket == null || SocketSDK.this.socket.isClosed() || !SocketSDK.this.socket.isConnected()) {
                    SocketSDK.this.connectedToPos = false;
                    Log.e((String)SocketSDK.LOG_TAG, (String)"Socket\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u65ad\u5f00\u8fde\u63a5\uff0c\u7a0b\u5e8f\u5c06\u4fdd\u8bc1Socket\u6240\u5360\u7528\u7684\u8d44\u6e90\u5f97\u5230\u91ca\u653e\u3002");
                    SocketSDK.this.clearSocket();
                    this.stop();
                    Log.e((String)SocketSDK.LOG_TAG, (String)"Socket\u72b6\u6001\u76d1\u63a7\u7ebf\u7a0b\u5173\u95ed");
                }
            }
        }
    }
}

