/*
 * Decompiled with CFR 0.152.
 */
package POSSDK;

import POSAPI.POSInterfaceAPI;
import POSSDK.LogManager;
import POSSDK.POSCommand;
import POSSDK.RecordData;
import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class POSSDK {
    private static final String LOG_TAG = "SNBC_POS";
    public static final int PRINT_MODE_STANDARD = 0;
    public static final int PRINT_MODE_PAGE = 1;
    public static final int PaperTypeCoutinuous = 0;
    public static final int PaperTypeMarked = 1;
    public static final int PaperTypeWhiteMarked = 2;
    public static final int CutFullImmdediately = 0;
    public static final int CutPartImmdediately = 1;
    public static final int CutPartAfterFeed = 66;
    public static final int CharacterSetUSA = 0;
    public static final int CharacterSetFrance = 1;
    public static final int CharacterSetGermany = 2;
    public static final int CharacterSetUK = 3;
    public static final int CharacterSetDenmark_I = 4;
    public static final int CharacterSetSweden = 5;
    public static final int CharacterSetItaly = 6;
    public static final int CharacterSetSpain_I = 7;
    public static final int CharacterSetJapan = 8;
    public static final int CharacterSetNorway = 9;
    public static final int CharacterSetDenmark_II = 10;
    public static final int CharacterSetSpain_II = 11;
    public static final int CharacterSetLatin_America = 12;
    public static final int CharacterSetKorea = 13;
    public static final int TextAlignmentLeft = 0;
    public static final int TextAlignmentCenter = 1;
    public static final int TextAlignmentRight = 2;
    public static final int RotatePrintNormal = 0;
    public static final int RotatePrintR90 = 1;
    public static final int RotatePrint180 = 2;
    public static final int RotatePrintL90 = 3;
    public static final int FontTypeStandardASCII = 0;
    public static final int FontTypeCompressedASCII = 1;
    public static final int FontTypeUserDefined = 2;
    public static final int FontTypeChinese = 3;
    public static final int FontStyleNormal = 0;
    public static final int FontStyleBold = 8;
    public static final int FontStyleUpsideDown = 512;
    public static final int FontStyleUnderlineOneDotThick = 128;
    public static final int FontStyleUnderlineTwoDotThick = 256;
    public static final int FontStyleReverse = 1024;
    public static final int FontStyleSmooth = 2048;
    public static final int BarcodeUPC_A = 65;
    public static final int BarcodeUPC_E = 66;
    public static final int BarcodeJAN13orEAN13 = 67;
    public static final int BarcodeJAN8orEAN8 = 68;
    public static final int BarcodeCODE39 = 69;
    public static final int BarcodeITF = 70;
    public static final int BarcodeCODABAR = 71;
    public static final int BarcodeCODE93 = 72;
    public static final int BarcodeCODE128 = 73;
    public static final int POS_SUCCESS = 1000;
    public static final int ERR_PROCESSING = 1001;
    public static final int ERR_PARAM = 1002;
    public static final int FIRSTPORT = 1;
    public static final int SECONDPORT = 2;
    public static final int WRITETIMEOUT = 90000;
    private static final String E = "E";
    private static final String D = "D";
    public static final int RECORD_LOG = 1;
    public static final int NO_RECODE_LOG = 0;
    public POSCommand pos_command;
    private int error_code = 0;
    private Lock m_Lock = new ReentrantLock();

    public POSSDK() {
    }

    public POSSDK(POSInterfaceAPI pos_interface) {
        this.pos_command = new POSCommand(pos_interface);
    }

    public int recordCommunicationData(Context contexts, int IsRecord, String FileName) {
        int result = 1000;
        if (IsRecord == 1) {
            RecordData.init(contexts, FileName);
        }
        return result;
    }

    public int LogTrace(Context contexts, int IsRecord, String FileName) {
        int result = 1000;
        if (IsRecord == 1) {
            LogManager.init(contexts, FileName);
        }
        return result;
    }

    public int systemReset() {
        LogManager.writeLog(D, "systemReset --enter");
        this.m_Lock.lock();
        this.error_code = this.pos_command._systemReset();
        this.error_code = this.pos_command._systemCloseQueryReturn();
        this.m_Lock.unlock();
        LogManager.writeLog(D, "systemReset --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int systemSelectPrintMode(int Mode) {
        LogManager.writeLog(D, "systemSelectPrintMode --enter,parameter:" + Mode);
        this.error_code = this.pos_command._systemSelectPrintMode(Mode);
        LogManager.writeLog(D, "systemSelectPrintMode --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int systemSelectPaperType(int PaperType) {
        LogManager.writeLog(D, "systemSelectPaperType --enter,parameter:" + PaperType);
        this.error_code = this.pos_command._systemSelectPaperType(PaperType);
        LogManager.writeLog(D, "systemSelectPaperType --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int systemSetMotionUnit(int HorizontalUnit, int VerticalUnit) {
        LogManager.writeLog(D, "systemSetMotionUni --enter,parameter:" + HorizontalUnit + "--" + VerticalUnit);
        this.error_code = this.pos_command._systemSetMotionUnit(HorizontalUnit, VerticalUnit);
        LogManager.writeLog(D, "systemSetMotionUni --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int systemQueryStatus(byte[] QueryStatusBuffer, int ReadSize, int Port_type) {
        LogManager.writeLog(D, "systemQueryStatus --enter");
        this.error_code = this.pos_command._systemQueryStatus(QueryStatusBuffer, ReadSize, Port_type);
        LogManager.writeLog(D, "systemQueryStatus --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int systemFeedLine(int LineNum) {
        LogManager.writeLog(D, "systemFeedLine --enter,parameter:" + LineNum);
        int i = 0;
        if (LineNum <= 0 || LineNum > 255) {
            return 1002;
        }
        this.m_Lock.lock();
        i = 0;
        while (i < LineNum) {
            this.error_code = this.pos_command._systemFeedLine();
            ++i;
        }
        this.m_Lock.unlock();
        LogManager.writeLog(D, "systemFeedLine --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int systemCutPaper(int CutMode, int FeedDistance) {
        LogManager.writeLog(D, "systemCutPaper --enter,parameter:" + CutMode + "--" + FeedDistance);
        this.error_code = this.pos_command._systemCutPaper(CutMode, FeedDistance);
        LogManager.writeLog(D, "systemCutPaper --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int systemDownloadFile(String FileName, int TimeOut) {
        LogManager.writeLog(D, "systemDownloadFile --enter");
        this.error_code = this.pos_command._systemDownloadFile(FileName, TimeOut);
        LogManager.writeLog(D, "systemDownloadFile --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int cashdrawerOpen(int CashdrawerID, int PulseOnTimes, int PulseOffTimes) {
        LogManager.writeLog(D, "cashdrawerOpen --enter,parameter:" + CashdrawerID + "--" + PulseOnTimes + "--" + PulseOffTimes);
        this.error_code = this.pos_command._cashdrawerOpen(CashdrawerID, PulseOnTimes, PulseOffTimes);
        LogManager.writeLog(D, "cashdrawerOpen --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int textSelectCharSetAndCodePage(int CharSet, int CodePage) {
        LogManager.writeLog(D, "textSelectCharSetAndCodePage --enter,parameter:" + CharSet + "--" + CodePage);
        this.m_Lock.lock();
        this.error_code = this.pos_command._textSelectCharSet(CharSet);
        if (this.error_code != 1000) {
            this.m_Lock.unlock();
            return this.error_code;
        }
        this.error_code = this.pos_command._textSelectCodePage(CodePage);
        this.m_Lock.unlock();
        LogManager.writeLog(D, "textSelectCharSetAndCodePage --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int textSetLineHeight(int Height) {
        LogManager.writeLog(D, "textSetLineHeight --enter,parameter:" + Height);
        this.error_code = this.pos_command._textSetLineHeight(Height);
        LogManager.writeLog(D, "textSetLineHeight --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int textSetCharacterSpace(int LeftSpace, int RightSpace, int Mode) {
        LogManager.writeLog(D, "textSetCharacterSpace --enter,parameter:" + LeftSpace + "--" + RightSpace + "--" + Mode);
        this.error_code = this.pos_command._textSetCharacterSpace(LeftSpace, RightSpace, Mode);
        LogManager.writeLog(D, "textSetCharacterSpace --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int textStandardModeAlignment(int Alignment2) {
        LogManager.writeLog(D, "textStandardModeAlignment --enter,parameter:" + Alignment2);
        this.error_code = this.pos_command._textStandardModeAlignment(Alignment2);
        LogManager.writeLog(D, "textStandardModeAlignment --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int textSetColorPrint(int Color2) {
        LogManager.writeLog(D, "textSetPrintColor --enter,parameter:" + Color2);
        this.error_code = this.pos_command._textSetColorPrint(Color2);
        LogManager.writeLog(D, "textSetPrintColor --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int textPrint(byte[] Buffer2, int BytesOfBuffer) {
        int nReturn = 0;
        LogManager.writeLog(D, "textPrint --enter");
        if (Buffer2 == null || BytesOfBuffer < 0) {
            return 1001;
        }
        nReturn = this.pos_command.WriteBuffer(Buffer2, 0, BytesOfBuffer, 90000);
        this.error_code = nReturn == BytesOfBuffer ? 1000 : 1001;
        LogManager.writeLog(D, "textPrint --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int textSelectFontMagnifyTimes(int HorizontalTimes, int VerticalTimes) {
        LogManager.writeLog(D, "textSelectFontMagnifyTimes --enter,parameter:" + HorizontalTimes + "--" + VerticalTimes);
        this.error_code = this.pos_command._textSelectFontMagnifyTimes(HorizontalTimes, VerticalTimes);
        LogManager.writeLog(D, "textSelectFontMagnifyTimes --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int textStandardModeRotate(int Rotate) {
        LogManager.writeLog(D, "textStandardModeRotate --enter,parameter:" + Rotate);
        this.error_code = this.pos_command._textStandardModeRotate(Rotate);
        LogManager.writeLog(D, "textStandardModeRotate --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int textStandardModeUpsideDown(int UpsideDown) {
        LogManager.writeLog(D, "textStandardModeUpsideDown --enter,parameter:" + UpsideDown);
        this.error_code = this.pos_command._textStandardModeUpsideDown(UpsideDown);
        LogManager.writeLog(D, "textStandardModeUpsideDown --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int textSelectFont(int FontType, int FontStyle) {
        int nHigh = FontStyle / 255;
        int nLow = FontStyle % 255;
        int nTemp = 0;
        LogManager.writeLog(D, "textSelectFont --enter,parameter:" + FontType + "--" + FontStyle);
        this.m_Lock.lock();
        this.error_code = this.pos_command._textSelectFontType(FontType);
        if (this.error_code != 1000) {
            LogManager.writeLog(D, "textSelectFont --out,_textSelectFontType::error_code=" + this.error_code);
            this.m_Lock.unlock();
            return this.error_code;
        }
        nTemp = nHigh >> 2 & 1;
        this.error_code = this.pos_command._textStyleReverse(nTemp);
        if (this.error_code != 1000) {
            LogManager.writeLog(D, "textSelectFont --out,_textStyleReverse::error_code=" + this.error_code);
            this.m_Lock.unlock();
            return this.error_code;
        }
        nTemp = nHigh >> 3 & 1;
        this.error_code = this.pos_command._textStyleSmooth(nTemp);
        if (this.error_code != 1000) {
            LogManager.writeLog(D, "textSelectFont --out,_textStyleSmooth::error_code=" + this.error_code);
            this.m_Lock.unlock();
            return this.error_code;
        }
        nTemp = nLow >> 3 & 1;
        this.error_code = this.pos_command._textStyleBold(nTemp);
        if (this.error_code != 1000) {
            LogManager.writeLog(D, "textSelectFont --out,_textStyleBold::error_code=" + this.error_code);
            this.m_Lock.unlock();
            return this.error_code;
        }
        nTemp = nHigh >> 1 & 1;
        this.error_code = this.pos_command._textStandardModeUpsideDown(nTemp);
        if (this.error_code != 1000) {
            LogManager.writeLog(D, "textSelectFont --out,_textStandardModeUpsideDown::error_code=" + this.error_code);
            this.m_Lock.unlock();
            return this.error_code;
        }
        this.error_code = (nLow & 0x80) == 128 ? this.pos_command._textStyleUnderline(1, FontType) : ((nHigh & 1) == 1 ? this.pos_command._textStyleUnderline(2, FontType) : this.pos_command._textStyleUnderline(0, FontType));
        this.m_Lock.unlock();
        LogManager.writeLog(D, "textSelectFont --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int textEnterOrQuitColorPrint(int ColorPrint) {
        LogManager.writeLog(D, "textEnterOrQuitColorPrint --enter,parameter:" + ColorPrint);
        this.error_code = this.pos_command._textEnterOrQuitColorPrint(ColorPrint);
        LogManager.writeLog(D, "textEnterOrQuitColorPrint --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int textUserDefinedCharacterEnable(int Enable) {
        LogManager.writeLog(D, "textUserDefinedCharacterEnable --enter,parameter:" + Enable);
        this.error_code = this.pos_command._textUserDefinedCharacterEnable(Enable);
        LogManager.writeLog(D, "textUserDefinedCharacterEnable --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int textUserDefinedCharacterDefine(int BytesOfHeight, int DotsOfWidth, int StartingCode, int EndingCode, Bitmap[] image) {
        LogManager.writeLog(D, "textUserDefinedCharacterDefine --enter,parameter:" + BytesOfHeight + "--" + DotsOfWidth + "--" + StartingCode + "--" + EndingCode);
        this.error_code = this.pos_command._textUserDefinedCharacterDefine(BytesOfHeight, DotsOfWidth, StartingCode, EndingCode, image);
        LogManager.writeLog(D, "textUserDefinedCharacterDefine --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int textUserDefinedCharacterCancel(int CharCode) {
        LogManager.writeLog(D, "textUserDefinedCharacterCancel --enter,parameter:" + CharCode);
        this.error_code = this.pos_command._textUserDefinedCharacterCancel(CharCode);
        LogManager.writeLog(D, "textUserDefinedCharacterCancel --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int imageStandardModePrint(Bitmap image, int SingleDoubleFlag, int StartHorPos, int PrinterWidth) {
        Bitmap m_image = null;
        if (PrinterWidth < 64 && PrinterWidth != 0 || PrinterWidth > 65535) {
            return 1002;
        }
        LogManager.writeLog(D, "imagePrint --enter,parameter:" + SingleDoubleFlag + "--" + StartHorPos + "--" + PrinterWidth);
        this.m_Lock.lock();
        m_image = this.pos_command._imageInitWithUIImage(image, PrinterWidth);
        if (m_image == null) {
            this.m_Lock.unlock();
            return 1001;
        }
        this.error_code = this.pos_command._imageDownLoadAndPrint(m_image, SingleDoubleFlag, StartHorPos);
        m_image.recycle();
        this.m_Lock.unlock();
        LogManager.writeLog(D, "imagePrint --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int imageDownloadToPrinterRAM(int ImageID, Bitmap image, int PrinterWidth) {
        Bitmap m_image = null;
        LogManager.writeLog(D, "imageDownloadToPrinterRAM --enter,parameter:" + ImageID + "--" + PrinterWidth);
        this.m_Lock.lock();
        m_image = this.pos_command._imageInitWithUIImage(image, PrinterWidth);
        if (m_image == null) {
            this.m_Lock.unlock();
            return 1001;
        }
        this.error_code = this.pos_command._imageDownloadToPrinterRAM(m_image, ImageID);
        m_image.recycle();
        this.m_Lock.unlock();
        LogManager.writeLog(D, "imageDownloadToPrinterRAM --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int imageRAMPrint(int ImageID, int Mode) {
        LogManager.writeLog(D, "imageRAMPrint --enter,parameter:" + ImageID + "--" + Mode);
        this.error_code = this.pos_command._imageRAMPrint(ImageID, Mode);
        LogManager.writeLog(D, "imageRAMPrint --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int imageDownloadToPrinterFlash(int image_num, Bitmap[] cg_image, int PrinterWidth) {
        Bitmap[] image = new Bitmap[image_num];
        int i = 0;
        LogManager.writeLog(D, "imageDownloadToPrinterFlash --enter,parameter:" + image_num + "--" + PrinterWidth);
        this.m_Lock.lock();
        i = 0;
        while (i < image_num) {
            image[i] = this.pos_command._imageInitWithUIImage(cg_image[i], PrinterWidth);
            if (image[i] == null) {
                this.m_Lock.unlock();
                return 1001;
            }
            ++i;
        }
        this.error_code = this.pos_command._imageDownloadToPrinterFlash(image_num, image);
        i = 0;
        while (i < image_num) {
            image[i].recycle();
            ++i;
        }
        this.m_Lock.unlock();
        LogManager.writeLog(D, "imageDownloadToPrinterFlash --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int imageFlashPrint(int ImageID, int Mode) {
        LogManager.writeLog(D, "imageFlashPrint --enter,parameter:" + ImageID + "--" + Mode);
        this.error_code = this.pos_command._imageFlashPrint(ImageID, Mode);
        LogManager.writeLog(D, "imageFlashPrint --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public Bitmap imageCreateRasterBitmap(String printText, int textSize, int bold) {
        LogManager.writeLog(D, "createRasterBitmap --enter,parameter:" + printText + "--" + textSize + "--" + bold);
        Bitmap image = this.pos_command._createRasterBitmap(printText, textSize, bold);
        LogManager.writeLog(D, "createRasterBitmap --out,error_code=" + this.error_code);
        return image;
    }

    public int imageStandardModeRasterPrint(Bitmap image, int PrinterWidth) {
        Bitmap m_image = null;
        LogManager.writeLog(D, "imageStandardModeRasterPrint --enter,parameter:" + PrinterWidth);
        if (PrinterWidth < 64 && PrinterWidth != 0 || PrinterWidth > 2040) {
            return 1002;
        }
        this.m_Lock.lock();
        m_image = this.pos_command._imageInitWithUIImage(image, PrinterWidth);
        if (m_image == null) {
            this.m_Lock.unlock();
            return 1001;
        }
        this.error_code = this.pos_command._imageStandardModeRasterPrint(m_image);
        m_image.recycle();
        this.m_Lock.unlock();
        LogManager.writeLog(D, "imageStandardModeRasterPrint --out,error_code=" + this.error_code);
        return this.error_code;
    }

    public int barcodePrint1Dimension(String pszBuffer, int DataLength, int nType, int nWidthX, int nHeight, int nHriFontType, int nHriFontPosition) {
        int result = 1000;
        byte[] send_buf = null;
        int buf_size = 0;
        LogManager.writeLog(D, "_barcodePrint1Dimension---parameter error, nType:" + nType + " nWidthX:" + nWidthX + " nHeight:" + nHeight + " nHriFontType:" + nHriFontType + " nBytesOfBuffer:" + DataLength);
        if (nType < 65 || nType > 73 || nWidthX < 2 || nWidthX > 6 || nHeight < 1 || nHeight > 255 || nHriFontType < 0 || nHriFontType > 1 || nHriFontPosition < 0 || nHriFontPosition > 3 || DataLength < 1) {
            Log.e((String)LOG_TAG, (String)("_barcodePrint1Dimension---parameter error, nType:" + nType + " nWidthX:" + nWidthX + " nHeight:" + nHeight + " nHriFontType:" + nHriFontType + " nBytesOfBuffer:" + DataLength));
            LogManager.writeLog(E, "_barcodePrint1Dimension---parameter error, nType:" + nType + " nWidthX:" + nWidthX + " nHeight:" + nHeight + " nHriFontType:" + nHriFontType + " nBytesOfBuffer:" + DataLength);
            return 1002;
        }
        if (nType == 65 && (DataLength < 11 || DataLength > 12)) {
            return 1002;
        }
        if (nType == 66 && (DataLength < 11 || DataLength > 12)) {
            return 1002;
        }
        if (nType == 67 && (DataLength < 12 || DataLength > 13)) {
            return 1002;
        }
        if (nType == 68 && (DataLength < 7 || DataLength > 8)) {
            return 1002;
        }
        if (nType == 69 && (DataLength < 1 || DataLength > 255)) {
            return 1002;
        }
        if (nType == 70 && (DataLength < 1 || DataLength > 255 || DataLength % 2 != 0)) {
            return 1002;
        }
        if (nType == 71 && (DataLength < 1 || DataLength > 255)) {
            return 1002;
        }
        if (nType == 72 && (DataLength < 1 || DataLength > 255)) {
            return 1002;
        }
        if (nType == 73 && (DataLength < 2 || DataLength > 255)) {
            return 1002;
        }
        try {
            send_buf = pszBuffer.getBytes("GB18030");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        buf_size = send_buf.length;
        if (buf_size < DataLength) {
            send_buf = null;
            return 1002;
        }
        this.m_Lock.lock();
        result = this.pos_command._barcodeSetModuleWidth(nWidthX);
        if (result != 1000) {
            this.m_Lock.unlock();
            return result;
        }
        result = this.pos_command._barcodeSelectBarcodeHeight(nHeight);
        if (result != 1000) {
            this.m_Lock.unlock();
            return result;
        }
        result = this.pos_command._barcodeSelectHriFontType(nHriFontType);
        if (result != 1000) {
            this.m_Lock.unlock();
            return result;
        }
        result = this.pos_command._barcodeSetHriFontPosition(nHriFontPosition);
        if (result != 1000) {
            this.m_Lock.unlock();
            return result;
        }
        result = this.pos_command._barcodePrint1Dimension(nType, DataLength);
        if (result != 1000) {
            this.m_Lock.unlock();
            return result;
        }
        result = this.pos_command.WriteBuffer(send_buf, 0, DataLength, 90000);
        send_buf = null;
        this.error_code = result == DataLength ? 1000 : 1001;
        this.m_Lock.unlock();
        Log.d((String)LOG_TAG, (String)("_barcodePrint1Dimension---out,error_code =" + this.error_code));
        LogManager.writeLog(D, "_barcodePrint1Dimension---out,error_code =" + this.error_code);
        return this.error_code;
    }

    public int barcodePrintQR(String pszBuffer, int DataLength, int nOrgx, int BasicElementWidth, int SymbolType, int LanguageMode) {
        int nReturn = 1000;
        byte[] send_buf = null;
        int buf_size = 0;
        Log.d((String)LOG_TAG, (String)("barcodePrintQR---enter,parameter:pszInfo:" + pszBuffer + ";nOrgx:" + nOrgx + ";BasicElementWidth:" + BasicElementWidth + ";SymbolType:" + SymbolType + ";iLanguageMode:" + LanguageMode + ";nBytesOfBuffer:" + DataLength));
        LogManager.writeLog(D, "barcodePrintQR---enter,parameter:pszInfo:" + pszBuffer + ";nOrgx:" + nOrgx + ";BasicElementWidth:" + BasicElementWidth + ";SymbolType:" + SymbolType + ";iLanguageMode:" + LanguageMode + ";nBytesOfBuffer:" + DataLength);
        if (nOrgx < 0 || nOrgx > 9999) {
            Log.e((String)LOG_TAG, (String)("barcodePrintQR---parameter error,nOrgx = " + nOrgx));
            LogManager.writeLog(E, "barcodePrintQR---parameter error,nOrgx = " + nOrgx);
            return 1002;
        }
        if (BasicElementWidth < 1 || BasicElementWidth > 10) {
            Log.e((String)LOG_TAG, (String)("barcodePrintQR---parameter error,BasicElementWidth =" + BasicElementWidth));
            LogManager.writeLog(E, "barcodePrintQR---parameter error,BasicElementWidth =" + BasicElementWidth);
            return 1002;
        }
        if (SymbolType < 1 || SymbolType > 2) {
            Log.e((String)LOG_TAG, (String)("barcodePrintQR---parameter error,iSymbolType = " + SymbolType));
            LogManager.writeLog(E, "barcodePrintQR---parameter error,iSymbolType = " + SymbolType);
            return 1002;
        }
        if (LanguageMode < 0 || LanguageMode > 1) {
            Log.e((String)LOG_TAG, (String)("barcodePrintQR---parameter error,iLanguageMode =" + LanguageMode));
            LogManager.writeLog(E, "barcodePrintQR---parameter error,iLanguageMode =" + LanguageMode);
            return 1002;
        }
        if (DataLength < 1 || pszBuffer.length() <= 0) {
            Log.e((String)LOG_TAG, (String)("barcodePrintQR---parameter error,pszInfo = " + pszBuffer));
            LogManager.writeLog(E, "barcodePrintQR---parameter error,pszInfo = " + pszBuffer);
            return 1002;
        }
        try {
            send_buf = pszBuffer.getBytes("GB18030");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        buf_size = send_buf.length;
        if (buf_size < DataLength) {
            send_buf = null;
            return 1002;
        }
        this.m_Lock.lock();
        nReturn = this.pos_command._standardModeSetHorStartingPosition(0, nOrgx);
        if (nReturn != 1000) {
            this.m_Lock.unlock();
            return 1001;
        }
        this.error_code = this.pos_command._barcodePrintQR(BasicElementWidth, SymbolType, LanguageMode);
        if (this.error_code != 1000) {
            this.m_Lock.unlock();
            return this.error_code;
        }
        this.error_code = this.pos_command._barcodePrint2Dimension(76, DataLength);
        if (this.error_code != 1000) {
            this.m_Lock.unlock();
            return this.error_code;
        }
        nReturn = this.pos_command.WriteBuffer(send_buf, 0, DataLength, 90000);
        send_buf = null;
        this.error_code = nReturn != DataLength ? 1001 : 1000;
        this.m_Lock.unlock();
        Log.d((String)LOG_TAG, (String)("barcodePrintQR---out,error_code = " + this.error_code));
        LogManager.writeLog(D, "barcodePrintQR---out,error_code = " + this.error_code);
        return this.error_code;
    }

    public int barcodePrintPDF417(String pszBuffer, int DataLength, int AppearanceToHeight, int AppearanceToWidth, int RowsNumber, int ColumnsNumber, int Xsize, int LineHeight, int nCorrectGrade) {
        int result = 0;
        byte[] send_buf = null;
        int buf_size = 0;
        LogManager.writeLog(D, "barcodePrintPDF417---enter,parameter:pszBuffer:" + pszBuffer + ";DataLength:" + DataLength + ";AppearanceToHeight:" + AppearanceToHeight + ";AppearanceToWidth:" + AppearanceToWidth + ";RowsNumber:" + RowsNumber + ";ColumnsNumber:" + ColumnsNumber + ";Xsize:" + Xsize + ";LineHeight:" + LineHeight + ";nCorrectGrade:" + nCorrectGrade);
        if (DataLength < 1 || pszBuffer.length() <= 0) {
            return 1002;
        }
        try {
            send_buf = pszBuffer.getBytes("GB18030");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        buf_size = send_buf.length;
        if (buf_size < DataLength) {
            send_buf = null;
            return 1002;
        }
        this.m_Lock.lock();
        if (this.pos_command._barcodePrintPDF417CorrectionGrade(nCorrectGrade) != 1000) {
            this.m_Lock.unlock();
            return 1001;
        }
        this.error_code = this.pos_command._barcodePrintPDF417(AppearanceToHeight, AppearanceToWidth, RowsNumber, ColumnsNumber, Xsize, LineHeight);
        if (this.error_code != 1000) {
            this.m_Lock.unlock();
            return this.error_code;
        }
        this.error_code = this.pos_command._barcodePrint2Dimension(75, DataLength);
        if (this.error_code != 1000) {
            this.m_Lock.unlock();
            return this.error_code;
        }
        result = this.pos_command.WriteBuffer(send_buf, 0, DataLength, 90000);
        send_buf = null;
        this.error_code = result != DataLength ? 1001 : 1000;
        this.m_Lock.unlock();
        LogManager.writeLog(D, "barcodePrintPDF417---out,error_code = " + this.error_code);
        return this.error_code;
    }

    public int barcodePrintMaxicode(String pszBuffer, int DataLength) {
        int result = 0;
        byte[] send_buf = null;
        int buf_size = 0;
        LogManager.writeLog(D, "barcodePrintMaxicode---enter,parameter:pszBuffer:" + pszBuffer + ";DataLength:" + DataLength);
        try {
            send_buf = pszBuffer.getBytes("GB18030");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        buf_size = send_buf.length;
        if (buf_size < DataLength) {
            send_buf = null;
            return 1002;
        }
        this.m_Lock.lock();
        this.error_code = this.pos_command._barcodePrint2Dimension(77, DataLength);
        if (this.error_code != 1000) {
            this.m_Lock.unlock();
            return this.error_code;
        }
        result = this.pos_command.WriteBuffer(send_buf, 0, DataLength, 90000);
        send_buf = null;
        this.error_code = result != DataLength ? 1001 : 1000;
        this.m_Lock.unlock();
        Log.d((String)LOG_TAG, (String)("barcodePrintMaxicode---out,error_code = " + this.error_code));
        LogManager.writeLog(D, "barcodePrintMaxicode---out,error_code = " + this.error_code);
        return this.error_code;
    }

    public int barcodePrintGS1DataBar(String pszBuffer, int DataLength, int BarcodeType, int BasicElementWidth, int BarcodeHeight, int BasicElementHeight, int SeparatorHeight, int SegmentHeight, int HRI, int AI) {
        int result = 0;
        byte[] send_buf = null;
        int buf_size = 0;
        LogManager.writeLog(D, "barcodePrintGS1DataBar---enter,parameter:pszBuffer:" + pszBuffer + ";DataLength:" + DataLength + ";BarcodeType:" + BarcodeType + ";BasicElementWidth:" + BasicElementWidth + ";BarcodeHeight:" + BarcodeHeight + ";BasicElementHeight:" + BasicElementHeight + ";SeparatorHeight:" + SeparatorHeight + ";SegmentHeight:" + SegmentHeight + ";HRI:" + HRI + ";AI:" + AI);
        try {
            send_buf = pszBuffer.getBytes("GB18030");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        buf_size = send_buf.length;
        if (buf_size < DataLength) {
            send_buf = null;
            return 1002;
        }
        this.m_Lock.lock();
        this.error_code = this.pos_command._barcodePrintGS1DataBar1Dimension(BarcodeType, BasicElementWidth, BarcodeHeight, BasicElementHeight, SeparatorHeight, SegmentHeight, HRI, AI);
        if (this.error_code != 1000) {
            this.m_Lock.unlock();
            return this.error_code;
        }
        this.error_code = this.pos_command._barcodePrint2Dimension(78, DataLength);
        if (this.error_code != 1000) {
            this.m_Lock.unlock();
            return this.error_code;
        }
        result = this.pos_command.WriteBuffer(send_buf, 0, DataLength, 90000);
        send_buf = null;
        this.error_code = result != DataLength ? 1001 : 1000;
        this.m_Lock.unlock();
        Log.d((String)LOG_TAG, (String)("barcodePrintGS1DataBar---out,error_code = " + this.error_code));
        LogManager.writeLog(D, "barcodePrintGS1DataBar---out,error_code = " + this.error_code);
        return this.error_code;
    }

    public int standardModeSetPrintAreaWidth(int LeftMargin, int Width) {
        LogManager.writeLog(D, "standardModeSetPrintAreaWidth---enter,parameter:" + LeftMargin + "--" + Width);
        if (LeftMargin < 0 || LeftMargin > 65535 || Width < 0 || Width > 65535) {
            return 1002;
        }
        this.m_Lock.lock();
        this.error_code = this.pos_command._standardModeSeLeftMargin(LeftMargin);
        if (this.error_code != 1000) {
            this.m_Lock.unlock();
            return this.error_code;
        }
        this.error_code = this.pos_command._standardModeSetPrintAreaWidth(Width);
        this.m_Lock.unlock();
        LogManager.writeLog(D, "standardModeSetPrintAreaWidth---out,error_code = " + this.error_code);
        return this.error_code;
    }

    public int pageModeSetPrintArea(int X, int Y, int AreaWidth, int AreaHeight, int Direction) {
        LogManager.writeLog(D, "pageModeSetPrintArea---enter,parameter:" + X + "--" + Y + "--" + AreaWidth + "--" + AreaHeight + "--" + Direction);
        if (X < 0 || X > 65535 || Y < 0 || Y > 65535 || AreaWidth < 0 || AreaWidth > 65535 || AreaHeight < 0 || AreaHeight > 65535 || Direction < 0 || Direction > 3) {
            return 1002;
        }
        this.m_Lock.lock();
        this.error_code = this.pos_command._pageModeSetPrintArea(X, Y, AreaWidth, AreaHeight);
        if (this.error_code != 1000) {
            this.m_Lock.unlock();
            LogManager.writeLog(D, "pageModeSetPrintArea---out,error_code = " + this.error_code);
            return this.error_code;
        }
        this.error_code = this.pos_command._pageModeSetPrintDirection(Direction);
        this.m_Lock.unlock();
        LogManager.writeLog(D, "pageModeSetPrintArea---out,error_code = " + this.error_code);
        return this.error_code;
    }

    public int standardModeSetStartingPosition(int X) {
        LogManager.writeLog(D, "standardModeSetStartingPosition---enter,parameter:" + X);
        this.error_code = this.pos_command._standardModeSetHorStartingPosition(0, X);
        LogManager.writeLog(D, "standardModeSetStartingPosition---out,error_code = " + this.error_code);
        return this.error_code;
    }

    public int pageModeSetStartingPosition(int X, int Y) {
        LogManager.writeLog(D, "pageModeSetStartingPosition---enter,parameter:" + X + "--" + Y);
        this.m_Lock.lock();
        this.error_code = this.pos_command._standardModeSetHorStartingPosition(0, X);
        if (this.error_code != 1000) {
            this.m_Lock.unlock();
            return this.error_code;
        }
        this.error_code = this.pos_command._pageModeSetVerStartingPosition(0, Y);
        this.m_Lock.unlock();
        LogManager.writeLog(D, "pageModeSetStartingPosition---out,error_code = " + this.error_code);
        return this.error_code;
    }

    public int pageModePrint() {
        LogManager.writeLog(D, "pageModePrint---enter");
        this.error_code = this.pos_command._pageModePrint();
        LogManager.writeLog(D, "pageModePrint---out,error_code = " + this.error_code);
        return this.error_code;
    }

    public int pageModeClearBuffer() {
        this.error_code = this.pos_command._pageModeClearBuffer();
        return this.error_code;
    }
}

