/*
 * Decompiled with CFR 0.152.
 */
package POSSDK;

import POSAPI.POSInterfaceAPI;
import POSSDK.LogManager;
import POSSDK.RecordData;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.Log;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class POSCommand {
    private static final String LOG_TAG = "SNBC_POS";
    public static final int POS_SUCCESS = 1000;
    public static final int ERR_PROCESSING = 1001;
    public static final int ERR_PARAM = 1002;
    public static final int ERR_SYSTEM_SELECT_PRINT_MODE = 1003;
    public static final int ERR_SYSTEM_SELECT_PAPER_TYPE = 1004;
    public static final int ERR_SYSTEM_SET_MOTION_UNIT = 1005;
    public static final int ERR_SYSTEM_QUERY_STATUS = 1006;
    public static final int ERR_SYSTEM_FEED_LINE = 1007;
    public static final int ERR_SYSTEM_CUT_PAPER = 1008;
    public static final int ERR_CASH_DRAWER_OPEN = 1009;
    public static final int ERR_TEXT_SELECT_CHAR_SET = 1010;
    public static final int ERR_TEXT_SELECT_CODE_PAGE = 1011;
    public static final int ERR_TEXT_SET_LINE_HEIGHT = 1012;
    public static final int ERR_TEXT_SET_CHARACTER_SPACE = 1013;
    public static final int ERR_TEXT_STANDARD_MODE_ALIGNMENT = 1014;
    public static final int ERR_TEXT_SELECT_FONT_TYPE = 1015;
    public static final int ERR_TEXT_SET_FONT_STYLE_REVERSE = 1016;
    public static final int ERR_TEXT_SET_FONT_STYLE_SMOOTH = 1017;
    public static final int ERR_TEXT_SET_FONT_STYLE_BOLD = 1018;
    public static final int ERR_TEXT_SET_FONT_STYLE_UNDERLINE = 1019;
    public static final int ERR_TEXT_STANDARD_MODE_UPSIDEDOWN = 1020;
    public static final int ERR_TEXT_SELECT_MAGNIFY_TIMES = 1021;
    public static final int ERR_TEXT_STANDARD_MODE_ROTATE = 1022;
    public static final int ERR_TEXT_ENTER_QUIT_COLOR_PRINT = 1023;
    public static final int ERR_TEXT_SET_COLOR_PRINT = 1024;
    public static final int ERR_TEXT_FONT_USER_DEFINED_ENABLE = 1025;
    public static final int ERR_TEXT_FONT_USER_DEFINED = 1026;
    public static final int ERR_TEXT_FONT_USER_DEFINED_CANCEL = 1027;
    public static final int ERR_IMAGE_DOWNLOAD_AND_PRINT = 1028;
    public static final int ERR_IMAGE_DOWNLOAD_RAM = 1029;
    public static final int ERR_IMAGE_RAM_PRINT = 1030;
    public static final int ERR_IMAGE_DOWNLOAD_FLASH = 1031;
    public static final int ERR_IMAGE_FLASH_PRINT = 1032;
    public static final int ERR_IMAGE_STANDARD_MODE_RASTER_PRINT = 1033;
    public static final int ERR_STANDARD_MODE_SET_PRINTAREA_WIDTH = 1034;
    public static final int ERR_STANDARD_MODE_SET_LEFT_MARGIN = 1035;
    public static final int ERR_STANDARD_MODE_SET_HORIZONTAL_STARTING_POSITION = 1036;
    public static final int ERR_PAGE_MODE_SET_VERTICAL_STARTING_POSITION = 1037;
    public static final int ERR_PAGE_MODE_SET_PRINT_AREA = 1038;
    public static final int ERR_PAGE_MODE_SET_PRINT_DIRECTION = 1039;
    public static final int ERR_PAGE_MODE_PRINT = 1040;
    public static final int ERR_PAGE_MODE_CLEAR_BUFFER = 1041;
    public static final int ERR_BARCODE_PRINT_1D = 1042;
    public static final int ERR_BARCODE_PRINT_2D = 1043;
    public static final int ERR_BARCODE_SELECT_MODULE_WIDTH = 1044;
    public static final int ERR_BARCODE_SELECT_BARCODE_HEIGHT = 1045;
    public static final int ERR_BARCODE_SELECT_HRI_FONT_TYPE = 1046;
    public static final int ERR_BARCODE_SELECT_HRI_FONT_POSITION = 1047;
    public static final int ERR_BARCODE_QR_SET_PARAM = 1048;
    public static final int ERR_BARCODE_PDF417_SELECT_CORRECTION_GRADE = 1049;
    public static final int ERR_BARCODE_PDF417_SET_SIZE = 1050;
    public static final int ERR_BARCODE_GS1DATABAR_SET_PARAM = 1051;
    public static final int ERR_COMMUNICATE = 1052;
    public static final int FIRSTPORT = 1;
    public static final int SECONDPORT = 2;
    public static final int RECORD_LOG = 1;
    public static final int NO_RECODE_LOG = 0;
    public static final int WRITETIMEOUT = 90000;
    private static final String D = "D";
    private static final String E = "E";
    private POSInterfaceAPI self_intface = null;
    private Lock m_Lock = new ReentrantLock();

    public POSCommand(POSInterfaceAPI pos_intface) {
        this.self_intface = pos_intface;
    }

    public synchronized int WriteBuffer(byte[] WriteBuffer, int OffsetSize, int nBytesToWrite, int WriteTimeOut) {
        if (WriteBuffer == null || nBytesToWrite <= 0 || OffsetSize < 0) {
            return 0;
        }
        int write_size = 0;
        byte[] des_buf = new byte[nBytesToWrite];
        Arrays.fill(des_buf, (byte)0);
        System.arraycopy(WriteBuffer, OffsetSize, des_buf, 0, nBytesToWrite);
        RecordData.writeLog(D, des_buf);
        write_size = this.self_intface.WriteBuffer(WriteBuffer, OffsetSize, nBytesToWrite, WriteTimeOut);
        des_buf = null;
        return write_size;
    }

    public synchronized int ReadBuffer(byte[] ReadBuffer, int OffsetSize, int nBytesToRead, int ReadTimeOut) {
        int read_size = 0;
        if (ReadBuffer == null || nBytesToRead <= 0 || OffsetSize < 0) {
            return 0;
        }
        read_size = this.self_intface.ReadBuffer(ReadBuffer, OffsetSize, nBytesToRead, ReadTimeOut);
        RecordData.writeLog(D, ReadBuffer);
        return read_size;
    }

    public synchronized int ReadBuffer(byte[] ReadBuffer, int OffsetSize, int nBytesToRead, int ReadTimeOut, int PortNum) {
        int read_size = 0;
        RecordData.writeLog(D, ReadBuffer);
        if (ReadBuffer == null || nBytesToRead <= 0 || OffsetSize < 0) {
            return 0;
        }
        read_size = this.self_intface.ReadBuffer(ReadBuffer, OffsetSize, nBytesToRead, ReadTimeOut, PortNum);
        RecordData.writeLog(D, ReadBuffer);
        if (read_size != nBytesToRead) {
            return 0;
        }
        return read_size;
    }

    public int recordCommunicationData(Context contexts, int IsRecord, String FileName) {
        int result = 1000;
        if (IsRecord == 1) {
            RecordData.init(contexts, FileName);
        }
        return result;
    }

    public int LogTrace(Context contexts, int IsRecord, String FileName) {
        int result = 1000;
        if (IsRecord == 1) {
            LogManager.init(contexts, FileName);
        }
        return result;
    }

    public int _systemReset() {
        int nReturn = 1000;
        byte[] pszCommand = new byte[]{27, 64};
        LogManager.writeLog(D, "_systemReset --enter.");
        nReturn = this.WriteBuffer(pszCommand, 0, 2, 90000);
        LogManager.writeLog(D, "_systemReset --out,nReturn=" + nReturn);
        if (nReturn == pszCommand.length) {
            pszCommand = null;
            return 1000;
        }
        return 1001;
    }

    public int _systemSelectPrintMode(int Mode) {
        int nReturn = 1000;
        byte[] pszCommandS = new byte[]{27, 83};
        byte[] pszCommandL = new byte[]{27, 76};
        LogManager.writeLog(D, "_systemSelectPrintMode --enter,parameter:" + Mode);
        if (Mode < 0 || Mode > 1) {
            LogManager.writeLog(E, "_systemSelectPrintMode --parameter error,parameter:Mode=" + Mode);
            return 1002;
        }
        nReturn = Mode == 0 ? this.WriteBuffer(pszCommandS, 0, 2, 90000) : this.WriteBuffer(pszCommandL, 0, 2, 90000);
        LogManager.writeLog(D, "_systemSelectPrintMode --out,nReturn=" + nReturn);
        if (nReturn == 2) {
            pszCommandS = null;
            pszCommandL = null;
            return 1000;
        }
        pszCommandS = null;
        pszCommandL = null;
        return 1003;
    }

    public int _systemSelectPaperType(int PaperType) {
        int nReturn = 1000;
        byte[] byArray = new byte[4];
        byArray[0] = 27;
        byArray[1] = 99;
        byArray[2] = 48;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_systemSelectPaperType --enter,parameter:" + PaperType);
        if (PaperType < 0 || PaperType > 2) {
            LogManager.writeLog(E, "_systemSelectPaperType --parameter error,parameter:PaperType=" + PaperType);
            return 1002;
        }
        if (PaperType == 0) {
            pszCommand[3] = (byte)PaperType;
        } else if (PaperType == 1) {
            pszCommand[3] = (byte)PaperType;
        } else if (PaperType == 2) {
            pszCommand[3] = (byte)PaperType;
        }
        nReturn = this.WriteBuffer(pszCommand, 0, 4, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_systemSelectPaperType --out,nReturn=" + nReturn);
        if (nReturn == 4) {
            return 1000;
        }
        return 1004;
    }

    public int _systemSetMotionUnit(int HorizontalUnit, int VerticalUnit) {
        int nReturn = 1000;
        byte[] byArray = new byte[4];
        byArray[0] = 29;
        byArray[1] = 80;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_systemSetMotionUnit --enter,parameter:" + HorizontalUnit + "--" + VerticalUnit);
        if (HorizontalUnit < 0 || HorizontalUnit > 255 || VerticalUnit < 0 || VerticalUnit > 255) {
            LogManager.writeLog(E, "_systemSetMotionUnit --parameter error,parameter:HorizontalUnit=" + HorizontalUnit + "VerticalUnit=" + VerticalUnit);
            return 1002;
        }
        pszCommand[2] = (byte)HorizontalUnit;
        pszCommand[3] = (byte)VerticalUnit;
        nReturn = this.WriteBuffer(pszCommand, 0, 4, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_systemSetMotionUnit --out,nReturn=" + nReturn);
        if (nReturn == 4) {
            return 1000;
        }
        return 1005;
    }

    public int _systemCloseQueryReturn() {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 29;
        byArray[1] = 97;
        byte[] pszCommand = byArray;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        if (nReturn == 3) {
            return 1000;
        }
        return 1006;
    }

    public int _systemQueryStatus(byte[] QueryStatusBuffer, int ReadSize, int Port_type) {
        int nReturn = 1000;
        int data_size = 0;
        byte[] sendbuf1 = new byte[]{29, 97, 15};
        byte[] sendbuf2 = new byte[]{27, 118};
        LogManager.writeLog(D, "_systemQueryStatus --enter,parameter:" + QueryStatusBuffer);
        if (QueryStatusBuffer == null || Port_type < 1 || Port_type > 4) {
            return 1002;
        }
        if (Port_type == 1) {
            data_size = this.WriteBuffer(sendbuf1, 0, sendbuf1.length, 90000);
            if (data_size != sendbuf1.length) {
                sendbuf1 = null;
                return 1006;
            }
            nReturn = this.ReadBuffer(QueryStatusBuffer, 0, ReadSize, 90000);
            LogManager.writeLog(D, "_systemQueryStatus --out,nReturn=" + nReturn);
            if (nReturn == ReadSize) {
                sendbuf1 = null;
                return 1000;
            }
            sendbuf1 = null;
            return 1006;
        }
        if (Port_type == 4) {
            data_size = this.WriteBuffer(sendbuf1, 0, sendbuf1.length, 90000);
            if (data_size != sendbuf1.length) {
                sendbuf1 = null;
                return 1006;
            }
            nReturn = this.ReadBuffer(QueryStatusBuffer, 0, ReadSize, 90000);
            LogManager.writeLog(D, "_systemQueryStatus --out,nReturn=" + nReturn);
            if (nReturn == ReadSize) {
                sendbuf1 = null;
                this._systemCloseQueryReturn();
                return 1000;
            }
            sendbuf1 = null;
            this._systemCloseQueryReturn();
            return 1006;
        }
        if (Port_type == 2) {
            data_size = this.WriteBuffer(sendbuf1, 0, sendbuf1.length, 90000);
            if (data_size != sendbuf1.length) {
                sendbuf1 = null;
                this._systemCloseQueryReturn();
                return 1006;
            }
            nReturn = this.ReadBuffer(QueryStatusBuffer, 0, QueryStatusBuffer.length, 90000);
            data_size = this.WriteBuffer(sendbuf1, 0, sendbuf1.length, 90000);
            if (data_size != sendbuf1.length) {
                sendbuf1 = null;
                this._systemCloseQueryReturn();
                return 1006;
            }
            nReturn = this.ReadBuffer(QueryStatusBuffer, 0, ReadSize, 90000);
            LogManager.writeLog(D, "_systemQueryStatus --out,nReturn=" + nReturn);
            if (nReturn == ReadSize) {
                sendbuf1 = null;
                this._systemCloseQueryReturn();
                return 1000;
            }
            sendbuf1 = null;
            this._systemCloseQueryReturn();
            return 1006;
        }
        if (Port_type == 3) {
            data_size = this.WriteBuffer(sendbuf2, 0, sendbuf2.length, 90000);
            if (data_size != sendbuf2.length) {
                sendbuf2 = null;
                return 1006;
            }
            nReturn = this.ReadBuffer(QueryStatusBuffer, 0, ReadSize, 90000);
            LogManager.writeLog(D, "_systemQueryStatus --out,nReturn=" + nReturn);
            if (nReturn == ReadSize) {
                sendbuf2 = null;
                return 1000;
            }
            sendbuf2 = null;
            return 1006;
        }
        return 1002;
    }

    public int _systemFeedLine() {
        int nReturn = 1000;
        byte[] pszCommand = new byte[]{10};
        LogManager.writeLog(D, "_systemFeedLine---enter");
        nReturn = this.WriteBuffer(pszCommand, 0, 1, 90000);
        LogManager.writeLog(D, "_systemFeedLine---out,nReturn =" + nReturn);
        if (nReturn == 1) {
            return 1000;
        }
        return 1007;
    }

    public int _systemCutPaper(int CutMode, int FeedDistance) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 29;
        byArray[1] = 86;
        byte[] pszCommand = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[0] = 29;
        byArray2[1] = 86;
        byte[] pszCommand2 = byArray2;
        LogManager.writeLog(D, "_systemCutPaper---enter,parameter:" + CutMode + "--" + FeedDistance);
        if (CutMode != 0 && CutMode != 1 && CutMode != 66 || FeedDistance < 0 || FeedDistance > 255) {
            LogManager.writeLog(E, "_systemCutPaper---parameter error,CutMode = " + CutMode + "FeedDistance = " + FeedDistance);
            return 1002;
        }
        if (CutMode == 0 || CutMode == 1) {
            pszCommand[2] = (byte)CutMode;
            nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        } else if (CutMode == 66) {
            pszCommand2[2] = 66;
            pszCommand2[3] = (byte)FeedDistance;
            nReturn = this.WriteBuffer(pszCommand2, 0, 4, 90000);
        }
        LogManager.writeLog(D, "_systemCutPaper---out,nReturn =" + nReturn);
        pszCommand = null;
        pszCommand2 = null;
        return 1000;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int _systemDownloadFile(String FileName, int timeout) {
        block18: {
            block17: {
                nReturn = 1000;
                data_buf = null;
                file_size = 0;
                BLOCK_MAX = 0x100000;
                temp = null;
                mode_len = 0;
                res_len = 0;
                count = 0;
                read_size = 0;
                Log.d((String)"SNBC_POS", (String)("_systemDownloadFile---enter,parameter:" + FileName));
                LogManager.writeLog("D", "_systemDownloadFile---enter,parameter:" + FileName);
                this.m_Lock.lock();
                try {
                    temp = new FileInputStream(FileName);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    this.m_Lock.unlock();
                    return 1002;
                }
                try {
                    file_size = temp.available();
                    Log.d((String)"SNBC_POS", (String)("_systemDownloadFile---into,file_size =" + file_size));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.m_Lock.unlock();
                    return 1002;
                }
                if (file_size <= 0x100000) break block17;
                data_buf = new byte[0x100000];
                Arrays.fill(data_buf, (byte)0);
                mode_len = file_size / 0x100000;
                res_len = file_size % 0x100000;
                count = 0;
                if (true) ** GOTO lbl72
            }
            try {
                data_buf = new byte[temp.available()];
                temp.read(data_buf);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.m_Lock.unlock();
                return 1052;
            }
            nReturn = this.WriteBuffer(data_buf, 0, data_buf.length, timeout);
            if (nReturn != data_buf.length) {
                data_buf = null;
                this.m_Lock.unlock();
                return 1052;
            }
            break block18;
            do {
                try {
                    read_size = temp.read(data_buf, 0, 0x100000);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.m_Lock.unlock();
                    return 1052;
                }
                if (read_size != 0x100000) {
                    data_buf = null;
                    this.m_Lock.unlock();
                    return 1052;
                }
                nReturn = this.WriteBuffer(data_buf, 0, 0x100000, timeout);
                if (nReturn != 0x100000) {
                    data_buf = null;
                    this.m_Lock.unlock();
                    return 1052;
                }
                ++count;
lbl72:
                // 2 sources

            } while (count < mode_len);
            if (res_len != 0) {
                read_size = 0;
                try {
                    read_size = temp.read(data_buf, 0, res_len);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.m_Lock.unlock();
                    return 1052;
                }
                if (read_size != res_len) {
                    data_buf = null;
                    this.m_Lock.unlock();
                    return 1052;
                }
                nReturn = this.WriteBuffer(data_buf, 0, read_size, timeout);
                if (nReturn != read_size) {
                    data_buf = null;
                    this.m_Lock.unlock();
                    return 1052;
                }
            }
        }
        data_buf = null;
        this.m_Lock.unlock();
        Log.d((String)"SNBC_POS", (String)("_systemDownloadFile---out,write_size =" + file_size));
        return 1000;
    }

    public int _cashdrawerOpen(int CashdrawerID, int PulseOnTimes, int PulseOffTimes) {
        int nReturn = 1000;
        byte[] byArray = new byte[5];
        byArray[0] = 27;
        byArray[1] = 112;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_cashdrawerOpen---enter,parameter:" + CashdrawerID + "--" + PulseOnTimes + "--" + PulseOnTimes);
        if (CashdrawerID != 0 && CashdrawerID != 1) {
            LogManager.writeLog(E, "_cashdrawerOpen---parameter error,nID =" + CashdrawerID);
            return 1002;
        }
        if (PulseOnTimes < 0 || PulseOnTimes > 255 || PulseOffTimes < 0 || PulseOffTimes > 255) {
            LogManager.writeLog(E, "_cashdrawerOpen---parameter error,PulseOnTimes =" + PulseOnTimes + "PulseOffTimes =" + PulseOffTimes);
            return 1002;
        }
        pszCommand[2] = (byte)CashdrawerID;
        pszCommand[3] = (byte)PulseOnTimes;
        pszCommand[4] = (byte)PulseOffTimes;
        nReturn = this.WriteBuffer(pszCommand, 0, 5, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_cashdrawerOpen---out,nReturn = " + nReturn);
        if (nReturn == 5) {
            return 1000;
        }
        return 1009;
    }

    public int _textSelectCharSet(int CharSet) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 82;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_textSelectCharSet --enter,parameter:" + CharSet);
        if (CharSet < 0 || CharSet > 13) {
            Log.e((String)LOG_TAG, (String)("_textSelectCharSet --parameter error,parameter:CharSet=" + CharSet));
            LogManager.writeLog(E, "_textSelectCharSet --parameter error,parameter:CharSet=" + CharSet);
            return 1002;
        }
        pszCommand[2] = (byte)CharSet;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_textSelectCharSet --out,nReturn=" + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1010;
    }

    public int _textSelectCodePage(int CodePage) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 116;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_textSelectCodePage --enter,parameter:" + CodePage);
        if (CodePage < 0 || CodePage > 255) {
            Log.e((String)LOG_TAG, (String)("_textSelectCodePage --parameter error,parameter:CodePage=" + CodePage));
            LogManager.writeLog(E, "_textSelectCodePage --parameter error,parameter:CodePage=" + CodePage);
            return 1002;
        }
        pszCommand[2] = (byte)CodePage;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_textSelectCodePage --out,nReturn=" + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1011;
    }

    public int _textSetLineHeight(int Height) {
        int nReturn = 1000;
        byte[] pszCommand1 = new byte[]{27, 50};
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 51;
        byte[] pszCommand2 = byArray;
        LogManager.writeLog(D, "_textSetLineHeight --enter,parameter:" + Height);
        if (Height < 0 || Height > 255) {
            Log.e((String)LOG_TAG, (String)("_textSetLineHeight --parameter error,parameter:Height=" + Height));
            LogManager.writeLog(E, "_textSetLineHeight --parameter error,parameter:Height=" + Height);
            return 1002;
        }
        if (Height == 0) {
            nReturn = this.WriteBuffer(pszCommand1, 0, 2, 90000);
            pszCommand1 = null;
            LogManager.writeLog(D, "_textSetLineHeight --out,nReturn=" + nReturn);
            if (nReturn == 2) {
                return 1000;
            }
            return 1012;
        }
        pszCommand2[2] = (byte)Height;
        nReturn = this.WriteBuffer(pszCommand2, 0, 3, 90000);
        pszCommand2 = null;
        LogManager.writeLog(D, "_textSetLineHeight --out,nReturn=" + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1012;
    }

    public int _textSetCharacterSpace(int LeftSpace, int RightSpace, int Mode) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 32;
        byte[] pszCommand = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[0] = 28;
        byArray2[1] = 83;
        byte[] pszCommand2 = byArray2;
        LogManager.writeLog(D, "_textSetCharacterSpace --enter,parameter:" + LeftSpace + "--" + RightSpace + "--" + Mode);
        if (LeftSpace < 0 || LeftSpace > 255 || RightSpace < 0 || RightSpace > 255 || Mode < 0 || Mode > 1) {
            LogManager.writeLog(E, "_textSetCharacterSpace --enter,parameter:" + LeftSpace + "--" + RightSpace + "--" + Mode);
            return 1002;
        }
        if (Mode == 1) {
            pszCommand[2] = (byte)RightSpace;
            nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
            pszCommand = null;
            if (nReturn != 3) {
                return 1013;
            }
        } else if (Mode == 0) {
            pszCommand2[2] = (byte)LeftSpace;
            pszCommand2[3] = (byte)RightSpace;
            nReturn = this.WriteBuffer(pszCommand2, 0, 4, 90000);
            pszCommand2 = null;
            if (nReturn != 4) {
                return 1013;
            }
        }
        LogManager.writeLog(D, "_textSetCharacterSpace---out,nReturn =" + nReturn);
        return 1000;
    }

    public int _textSelectFontType(int FontType) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 77;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_textSelectFontType---enter,parameter:" + FontType);
        if (FontType < 0 || FontType > 3) {
            LogManager.writeLog(E, "_textSelectFontType---parameter error,FontType =" + FontType);
            return 1002;
        }
        pszCommand[2] = (byte)FontType;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_textSelectFontType---out,nReturn =" + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1015;
    }

    public int _textStyleReverse(int Reverse) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 29;
        byArray[1] = 66;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_textStyleReverse---enter,parameter:" + Reverse);
        if (Reverse != 0 && Reverse != 1) {
            LogManager.writeLog(E, "_textStyleReverse---parameter error,Reverse = " + Reverse);
            return 1002;
        }
        pszCommand[2] = (byte)Reverse;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_textStyleReverse---out,nReturn =" + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1016;
    }

    public int _textStyleSmooth(int Smooth) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 29;
        byArray[1] = 98;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_textStyleSmooth---enter,parameter:" + Smooth);
        if (Smooth != 0 && Smooth != 1) {
            LogManager.writeLog(E, "_textStyleSmooth---parameter error,Smooth =" + Smooth);
            return 1002;
        }
        pszCommand[2] = (byte)Smooth;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_textStyleSmooth---out,nReturn =" + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1017;
    }

    public int _textStyleBold(int Bold) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 69;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_textStyleBold---enter,parameter:" + Bold);
        if (Bold != 0 && Bold != 1) {
            LogManager.writeLog(E, "_textStyleBold---parameter error,Bold = " + Bold);
            return 1002;
        }
        pszCommand[2] = (byte)Bold;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_textStyleBold---out,nReturn = " + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1018;
    }

    public int _textStyleUnderline(int Underline, int font_type) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 45;
        byte[] pszCommand1 = byArray;
        byte[] byArray2 = new byte[3];
        byArray2[0] = 28;
        byArray2[1] = 45;
        byte[] pszCommand2 = byArray2;
        LogManager.writeLog(D, "_textStyleUnderline---enter,parameter:" + Underline + "--" + font_type);
        if (Underline != 0 && Underline != 1 && Underline != 2) {
            Log.e((String)LOG_TAG, (String)("_textStyleUnderline---parameter error,Underline = " + Underline));
            LogManager.writeLog(E, "_textStyleUnderline---parameter error,Underline = " + Underline);
            return 1002;
        }
        if (font_type < 0 || font_type > 3) {
            Log.e((String)LOG_TAG, (String)("_textStyleUnderline---parameter error,font_type = " + font_type));
            LogManager.writeLog(E, "_textStyleUnderline---parameter error,font_type = " + font_type);
            return 1002;
        }
        if (font_type != 3) {
            pszCommand1[2] = (byte)Underline;
            nReturn = this.WriteBuffer(pszCommand1, 0, 3, 90000);
            pszCommand1 = null;
        } else {
            pszCommand2[2] = (byte)Underline;
            nReturn = this.WriteBuffer(pszCommand2, 0, 3, 90000);
            pszCommand2 = null;
        }
        LogManager.writeLog(D, "_textStyleUnderline---out,nReturn =" + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1019;
    }

    public int _textStandardModeUpsideDown(int UpsideDown) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 123;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_textStandardModeUpsideDown---enter,parameter:" + UpsideDown);
        if (UpsideDown != 0 && UpsideDown != 1) {
            Log.e((String)LOG_TAG, (String)("_textStandardModeUpsideDown---parameter error,UpsideDown =" + UpsideDown));
            LogManager.writeLog(E, "_textStandardModeUpsideDown---parameter error,UpsideDown =" + UpsideDown);
            return 1002;
        }
        pszCommand[2] = (byte)UpsideDown;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_textStandardModeUpsideDown---out,nReturn =" + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1020;
    }

    public int _textStandardModeAlignment(int Alignment2) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 97;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_textStandardModeAlignment---enter,parameter:" + Alignment2);
        if (Alignment2 != 0 && Alignment2 != 1 && Alignment2 != 2) {
            LogManager.writeLog(E, "_textStandardModeAlignment---parameter error,Alignment =" + Alignment2);
            return 1002;
        }
        pszCommand[2] = (byte)Alignment2;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_textStandardModeAlignment---out,nReturn =" + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1014;
    }

    public int _textSelectFontMagnifyTimes(int HorizontalTimes, int VerticalTimes) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 29;
        byArray[1] = 33;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_textSelectFontMagnifyTimes---enter,parameter:" + VerticalTimes + "--" + HorizontalTimes);
        if (VerticalTimes < 1 || VerticalTimes > 6 || HorizontalTimes < 1 || HorizontalTimes > 6) {
            LogManager.writeLog(E, "_textSelectFontMagnifyTimes---parameter error,VerticalTimes = " + VerticalTimes + "HorizontalTimes = " + HorizontalTimes);
            return 1002;
        }
        --HorizontalTimes;
        int nTimes = 0;
        pszCommand[2] = (byte)(nTimes |= (HorizontalTimes <<= 4) | --VerticalTimes);
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_textSelectFontMagnifyTimes---out,nReturn = " + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1021;
    }

    public int _textStandardModeRotate(int Rotate) {
        int nReturn = 1000;
        byte[] pszCommand = null;
        LogManager.writeLog(D, "_textStandardModeRotate---enter,parameter:" + Rotate);
        if (Rotate != 0 && Rotate != 1 && Rotate != 2 && Rotate != 3) {
            LogManager.writeLog(E, "_textStandardModeRotate---parameter error,Rotate = " + Rotate);
            return 1002;
        }
        if (Rotate == 0) {
            pszCommand = new byte[]{27, 123, 0, 27, 86, 0};
        } else if (Rotate == 1) {
            pszCommand = new byte[]{27, 123, 0, 27, 86, 1};
        } else if (Rotate == 2) {
            pszCommand = new byte[]{27, 86, 0, 27, 123, 1};
        } else if (Rotate == 3) {
            pszCommand = new byte[]{27, 86, 1, 27, 123, 1};
        }
        nReturn = this.WriteBuffer(pszCommand, 0, pszCommand.length, 90000);
        LogManager.writeLog(D, "_textStandardModeRotate---out,nReturn = " + nReturn);
        if (nReturn == pszCommand.length) {
            pszCommand = null;
            return 1000;
        }
        return 1022;
    }

    public int _textSetColorPrint(int Color) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 67;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_textSetPrintColor---enter,parameter:" + Color);
        if (Color < 0 || Color > 1) {
            LogManager.writeLog(E, "_textSetPrintColor---parameter error,Color = " + Color);
            return 1002;
        }
        pszCommand[2] = (byte)Color;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_textSetPrintColor---out,nReturn = " + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1024;
    }

    public int _textEnterOrQuitColorPrint(int ColorPrint) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 114;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_textEnterOrQuitColorPrint---enter,parameter:" + ColorPrint);
        if (ColorPrint < 0 || ColorPrint > 1) {
            LogManager.writeLog(E, "_textEnterOrQuitColorPrint---parameter error,ColorPrint = " + ColorPrint);
            return 1002;
        }
        pszCommand[2] = (byte)ColorPrint;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_textEnterOrQuitColorPrint---out,nReturn = " + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1023;
    }

    public int _textUserDefinedCharacterEnable(int Enable) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 37;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_textUserDefinedCharacterEnable---enter,parameter:" + Enable);
        if (Enable < 0 || Enable > 1) {
            LogManager.writeLog(E, "_textUserDefinedCharacterEnable---parameter error,ColorPrint = " + Enable);
            return 1002;
        }
        pszCommand[2] = (byte)Enable;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_textUserDefinedCharacterEnable---out,nReturn = " + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1025;
    }

    public int _imageFormatConvertToUserDefinedData(Bitmap image, byte[] img_buf) {
        int nReturn = 1000;
        byte[] BitMask1 = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
        this.m_Lock.lock();
        int image_w_src = image.getWidth();
        int image_h_src = image.getHeight();
        int image_width = image_w_src;
        int image_height = image_h_src + 7 >> 3 << 3;
        int col_index_src = 0;
        while (col_index_src < image_w_src) {
            int row_index_src = 0;
            while (row_index_src < image_h_src) {
                int Pixel_val = image.getPixel(col_index_src, row_index_src);
                int gray_val = this._getGreyLevel(Pixel_val, 1.0f);
                if (gray_val < 127) {
                    int n = (image_height >> 3) * col_index_src + (row_index_src >> 3);
                    img_buf[n] = (byte)(img_buf[n] | BitMask1[row_index_src & 7]);
                }
                ++row_index_src;
            }
            ++col_index_src;
        }
        this.m_Lock.unlock();
        return 1000;
    }

    public int _textUserDefinedCharacterDefine(int BytesOfHeight, int DotsOfWidth, int StartingCode, int EndingCode, Bitmap[] image) {
        int nReturn = 1000;
        byte[] byArray = new byte[6];
        byArray[0] = 27;
        byArray[1] = 38;
        byte[] pszCommand = byArray;
        byte[] img_buf = null;
        int img_height = 0;
        int img_width = 0;
        int image_h_src = 0;
        int image_w_src = 0;
        boolean image_row_bytes = false;
        int image_data_len = 0;
        int charNum = 0;
        int index = 0;
        LogManager.writeLog(D, "_textUserDefinedCharacterDefine---enter,parameter:" + BytesOfHeight + "--" + DotsOfWidth + "--" + StartingCode + "--" + EndingCode);
        if (BytesOfHeight < 1 || BytesOfHeight > 3 || DotsOfWidth < 1 || DotsOfWidth > 48 || StartingCode < 32 || StartingCode > 127 || EndingCode < 32 || EndingCode > 127 || StartingCode > EndingCode) {
            return 1002;
        }
        this.m_Lock.lock();
        pszCommand[2] = (byte)BytesOfHeight;
        pszCommand[3] = (byte)StartingCode;
        pszCommand[4] = (byte)EndingCode;
        pszCommand[5] = (byte)DotsOfWidth;
        nReturn = this.WriteBuffer(pszCommand, 0, 5, 90000);
        if (nReturn != 5) {
            this.m_Lock.unlock();
            return 1026;
        }
        charNum = EndingCode - StartingCode + 1;
        index = 0;
        while (index < charNum) {
            image_h_src = image[index].getHeight();
            img_width = image_w_src = image[index].getWidth();
            img_height = image_h_src + 7 >> 3 << 3;
            image_row_bytes = false;
            image_data_len = (img_height >> 3) * img_width;
            img_buf = new byte[image_data_len];
            Arrays.fill(img_buf, (byte)0);
            nReturn = this.WriteBuffer(pszCommand, 5, 1, 90000);
            if (nReturn != 1) {
                this.m_Lock.unlock();
                return 1026;
            }
            nReturn = this._imageFormatConvertToUserDefinedData(image[index], img_buf);
            if (nReturn != 1000) {
                this.m_Lock.unlock();
                return nReturn;
            }
            nReturn = this.WriteBuffer(img_buf, 0, img_buf.length, 90000);
            if (nReturn != img_buf.length) {
                this.m_Lock.unlock();
                return 1026;
            }
            img_buf = null;
            ++index;
        }
        LogManager.writeLog(D, "_textUserDefinedCharacterDefine---out,nReturn = 1000");
        this.m_Lock.unlock();
        return 1000;
    }

    public int _textUserDefinedCharacterCancel(int CharCode) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 63;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_textUserDefinedCharacterCancel---enter,parameter:" + CharCode);
        if (CharCode < 32 || CharCode > 127) {
            LogManager.writeLog(E, "_textUserDefinedCharacterCancel---parameter error,CharCode = " + CharCode);
            return 1002;
        }
        pszCommand[2] = (byte)CharCode;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_textUserDefinedCharacterCancel---out,nReturn = " + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1027;
    }

    public int _standardModeSetPrintAreaWidth(int Width) {
        int nReturn = 1000;
        byte[] byArray = new byte[4];
        byArray[0] = 29;
        byArray[1] = 87;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_standardModeSetPrintAreaWidth---enter,parameter:" + Width);
        if (Width < 0 || Width > 65535) {
            LogManager.writeLog(E, "_standardModeSetPrintAreaWidth---parameter error,Width = " + Width);
            return 1002;
        }
        int nHigh = Width / 256;
        int nLow = Width % 256;
        pszCommand[2] = (byte)nLow;
        pszCommand[3] = (byte)nHigh;
        nReturn = this.WriteBuffer(pszCommand, 0, 4, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_standardModeSetPrintAreaWidth---out,nReturn = " + nReturn);
        if (nReturn == 4) {
            return 1000;
        }
        return 1034;
    }

    public int _standardModeSeLeftMargin(int LeftMargin) {
        int nReturn = 1000;
        byte[] byArray = new byte[4];
        byArray[0] = 29;
        byArray[1] = 76;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_standardModeSeLeftMargin---enter,parameter:" + LeftMargin);
        if (LeftMargin < 0 || LeftMargin > 65535) {
            LogManager.writeLog(E, "_standardModeSeLeftMargin---parameter error,LeftMargin = " + LeftMargin);
            return 1002;
        }
        pszCommand[2] = (byte)((byte)LeftMargin % 256);
        pszCommand[3] = (byte)((byte)LeftMargin / 256);
        nReturn = this.WriteBuffer(pszCommand, 0, 4, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_standardModeSeLeftMargin---out,nReturn = " + nReturn);
        if (nReturn == 4) {
            return 1000;
        }
        return 1035;
    }

    public int _standardModeSetHorStartingPosition(int Mode, int Distance) {
        LogManager.writeLog(D, "_standardModeSetHorStartingPosition---enter,parameter:" + Mode + "--" + Distance);
        if (Distance < 0 || Distance > 65535) {
            LogManager.writeLog(E, "_standardModeSetHorStartingPosition---parameter error,Distance =" + Distance);
            return 1001;
        }
        int nHigh = Distance / 256;
        int nLow = Distance % 256;
        int nReturn = 1000;
        byte[] pszCommand = new byte[4];
        Arrays.fill(pszCommand, (byte)0);
        pszCommand[0] = 27;
        pszCommand[1] = 0;
        pszCommand[2] = (byte)nLow;
        pszCommand[3] = (byte)nHigh;
        pszCommand[1] = Mode == 0 ? 36 : 92;
        nReturn = this.WriteBuffer(pszCommand, 0, 4, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_standardModeSetHorStartingPosition---out,nReturn =" + nReturn);
        if (nReturn == 4) {
            return 1000;
        }
        return 1036;
    }

    public int _pageModeSetVerStartingPosition(int Mode, int Distance) {
        LogManager.writeLog(D, "_pageModeSetVerStartingPosition---enter,parameter:" + Mode + "--" + Distance);
        if (Distance < 0 || Distance > 65535 || Mode < 0 || Mode > 1) {
            LogManager.writeLog(E, "_pageModeSetVerStartingPosition---parameter error,nDistance =" + Distance);
            return 1002;
        }
        int nHigh = Distance / 256;
        int nLow = Distance % 256;
        int nReturn = 1000;
        byte[] pszCommand = new byte[4];
        Arrays.fill(pszCommand, (byte)0);
        pszCommand[0] = 29;
        pszCommand[1] = 0;
        pszCommand[2] = (byte)nLow;
        pszCommand[3] = (byte)nHigh;
        pszCommand[1] = Mode == 0 ? 36 : 92;
        nReturn = this.WriteBuffer(pszCommand, 0, 4, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_pageModeSetVerStartingPosition---out,nReturn = " + nReturn);
        if (nReturn == 4) {
            return 1000;
        }
        return 1037;
    }

    public int _pageModeSetPrintArea(int X, int Y, int AreaWidth, int AreaHeight) {
        LogManager.writeLog(D, "_pageModeSetPrintArea---enter,parameter:nOrgx" + X + "nOrgy" + Y + "nWidth" + AreaWidth + "nHeight" + AreaHeight);
        if (X < 0 || X > 65535 || Y < 0 || Y > 65535 || AreaWidth < 0 || AreaWidth > 65535 || AreaHeight < 0 || AreaHeight > 65535) {
            LogManager.writeLog(E, "_pageModeSetPrintArea---enter,parameter:nOrgx" + X + "nOrgy" + Y + "nWidth" + AreaWidth + "nHeight" + AreaHeight);
            return 1002;
        }
        int nReturn = 1000;
        byte[] pszCommand = new byte[10];
        Arrays.fill(pszCommand, (byte)0);
        int nOrgxH = X / 256;
        int nOrgxL = X % 256;
        int nOrgyH = Y / 256;
        int nOrgyL = Y % 256;
        int nWidthH = AreaWidth / 256;
        int nWidthL = AreaWidth % 256;
        int nHighH = AreaHeight / 256;
        int nHighL = AreaHeight % 256;
        pszCommand[0] = 27;
        pszCommand[1] = 87;
        pszCommand[2] = (byte)nOrgxL;
        pszCommand[3] = (byte)nOrgxH;
        pszCommand[4] = (byte)nOrgyL;
        pszCommand[5] = (byte)nOrgyH;
        pszCommand[6] = (byte)nWidthL;
        pszCommand[7] = (byte)nWidthH;
        pszCommand[8] = (byte)nHighL;
        pszCommand[9] = (byte)nHighH;
        nReturn = this.WriteBuffer(pszCommand, 0, 10, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_pageModeSetPrintArea---out,nReturn = " + nReturn);
        if (nReturn == 10) {
            return 1000;
        }
        return 1038;
    }

    public int _pageModeSetPrintDirection(int Direction) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 84;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_pageModeSetPrintDirection---enter,parameter:" + Direction);
        if (Direction < 0 || Direction > 3) {
            LogManager.writeLog(E, "_pageModeSetPrintDirection---parameter error,Direction = " + Direction);
            return 1002;
        }
        pszCommand[2] = (byte)Direction;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_pageModeSetPrintDirection---out,nReturn = " + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1039;
    }

    public int _pageModePrint() {
        int nReturn = 1000;
        byte[] pszCommand = new byte[]{27, 12};
        LogManager.writeLog(D, "_pageModePrint---enter");
        nReturn = this.WriteBuffer(pszCommand, 0, 2, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_pageModePrint---out,nReturn = " + nReturn);
        if (nReturn == 2) {
            return 1000;
        }
        return 1040;
    }

    public int _pageModeClearBuffer() {
        LogManager.writeLog(D, "_pageModeClearBuffer---enter");
        int nReturn = 1000;
        byte[] pszCommand = new byte[1];
        Arrays.fill(pszCommand, (byte)0);
        pszCommand[0] = 24;
        nReturn = this.WriteBuffer(pszCommand, 0, 1, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_pageModeClearBuffer---out,nReturn =" + nReturn);
        if (nReturn != 1) {
            return 1041;
        }
        return 1000;
    }

    public int _barcodeSetModuleWidth(int ModuleWidth) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 29;
        byArray[1] = 119;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_barcodeSetModuleWidth---enter,parameter:" + ModuleWidth);
        if (ModuleWidth < 2 || ModuleWidth > 6) {
            LogManager.writeLog(E, "_barcodeSetModuleWidth---parameter error,ModuleWidth = " + ModuleWidth);
            return 1002;
        }
        pszCommand[2] = (byte)ModuleWidth;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_barcodeSetModuleWidth---out,nReturn = " + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1044;
    }

    public int _barcodeSelectBarcodeHeight(int BarcodeHeight) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 29;
        byArray[1] = 104;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_barcodeSelectBarcodeHeight---enter,parameter:" + BarcodeHeight);
        if (BarcodeHeight < 0 || BarcodeHeight > 255) {
            LogManager.writeLog(E, "_barcodeSelectBarcodeHeight---parameter error,BarcodeHeight =" + BarcodeHeight);
            return 1002;
        }
        pszCommand[2] = (byte)BarcodeHeight;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_barcodeSelectBarcodeHeight---out,nReturn =" + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1045;
    }

    public int _barcodeSelectHriFontType(int HriFontType) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 29;
        byArray[1] = 102;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_barcodeSelectHriFontType---enter,parameter:" + HriFontType);
        if (HriFontType != 0 && HriFontType != 1) {
            LogManager.writeLog(E, "_barcodeSelectHriFontType---parameter error,HriFontType = " + HriFontType);
            return 1002;
        }
        pszCommand[2] = (byte)HriFontType;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_barcodeSelectHriFontType---out,nReturn =" + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1046;
    }

    public int _barcodeSetHriFontPosition(int Position) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 29;
        byArray[1] = 72;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_barcodeSetHriFontPosition---enter,parameter:" + Position);
        if (Position < 0 || Position > 3) {
            LogManager.writeLog(E, "_barcodeSetHriFontPosition---parameter error,Position =" + Position);
            return 1002;
        }
        pszCommand[2] = (byte)Position;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_barcodeSetHriFontPosition---out,nReturn = " + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1047;
    }

    public int _barcodePrintQR(int BasicElementWidth, int SymbolType, int LanguageMode) {
        int result = 1000;
        LogManager.writeLog(D, "_barcodePrintQR---enter,parameter:" + BasicElementWidth + "--" + SymbolType + "--" + LanguageMode);
        if (BasicElementWidth < 1 || BasicElementWidth > 10) {
            LogManager.writeLog(E, "POSSBarcodeQR---parameter error,BasicElementWidth =" + BasicElementWidth);
            return 1002;
        }
        if (SymbolType < 1 || SymbolType > 2) {
            LogManager.writeLog(E, "POSSBarcodeQR---parameter error,SymbolType = " + SymbolType);
            return 1001;
        }
        if (LanguageMode < 0 || LanguageMode > 1) {
            LogManager.writeLog(E, "POSSBarcodeQR---parameter error,LanguageMode =" + LanguageMode);
            return 1001;
        }
        byte[] pszCommand = new byte[6];
        Arrays.fill(pszCommand, (byte)0);
        pszCommand[0] = 29;
        pszCommand[1] = 111;
        pszCommand[2] = 0;
        pszCommand[3] = (byte)BasicElementWidth;
        pszCommand[4] = (byte)LanguageMode;
        pszCommand[5] = (byte)SymbolType;
        result = this.WriteBuffer(pszCommand, 0, pszCommand.length, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_barcodePrintQR---out,nReturn = " + result);
        if (result == 6) {
            return 1000;
        }
        return 1048;
    }

    public int _barcodePrintPDF417CorrectionGrade(int CorrectionGrade) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 29;
        byArray[1] = 113;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_barcodePrintPDF417CorrectionGrade---enter,parameter:" + CorrectionGrade);
        if (CorrectionGrade < 0 || CorrectionGrade > 8) {
            LogManager.writeLog(E, "_barcodePrintPDF417CorrectionGrade---parameter error,CorrectionGrade =" + CorrectionGrade);
            return 1002;
        }
        pszCommand[2] = (byte)CorrectionGrade;
        nReturn = this.WriteBuffer(pszCommand, 0, 3, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_barcodePrintPDF417CorrectionGrade---out,nReturn = " + nReturn);
        if (nReturn == 3) {
            return 1000;
        }
        return 1049;
    }

    public int _barcodePrintPDF417(int AppearanceToHeight, int AppearanceToWidth, int RowsNumber, int ColumnsNumber, int Xsize, int LineHeight) {
        int nReturn = 1000;
        LogManager.writeLog(D, "_barcodePrintPDF417---enter,parameter:;AppearanceToHeight:" + AppearanceToHeight + ";AppearanceToWidth:" + AppearanceToWidth + "RowsNumber:" + RowsNumber + ";ColumnsNumber:" + ColumnsNumber + ";Xsize:" + Xsize + ";LineHeight:" + LineHeight);
        if (RowsNumber < 3 || RowsNumber > 90 || ColumnsNumber < 1 || ColumnsNumber > 30 || AppearanceToHeight < 1 || AppearanceToHeight > 10 || AppearanceToWidth < 1 || AppearanceToWidth > 100 || Xsize < 1 || Xsize > 7 || LineHeight < 2 || LineHeight > 25) {
            LogManager.writeLog(E, "_barcodePrintPDF417---error,parameter:;AppearanceToHeight:" + AppearanceToHeight + ";AppearanceToWidth:" + AppearanceToWidth + "RowsNumber:" + RowsNumber + ";ColumnsNumber:" + ColumnsNumber + ";Xsize:" + Xsize + ";LineHeight:" + LineHeight);
            return 1002;
        }
        byte[] pszCommand = new byte[8];
        Arrays.fill(pszCommand, (byte)0);
        pszCommand[0] = 29;
        pszCommand[1] = 112;
        pszCommand[2] = (byte)AppearanceToHeight;
        pszCommand[3] = (byte)AppearanceToWidth;
        pszCommand[4] = (byte)RowsNumber;
        pszCommand[5] = (byte)ColumnsNumber;
        pszCommand[6] = (byte)Xsize;
        pszCommand[7] = (byte)LineHeight;
        nReturn = this.WriteBuffer(pszCommand, 0, 8, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_barcodePrintPDF417---out,nReturn = " + nReturn);
        if (nReturn == 8) {
            return 1000;
        }
        return 1050;
    }

    public int _barcodePrint1Dimension(int BarcodeType, int DataLength) {
        int nReturn = 0;
        byte[] byArray = new byte[4];
        byArray[0] = 29;
        byArray[1] = 107;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_barcodePrintDimension---enter,parameter:" + BarcodeType + "--" + DataLength);
        if (BarcodeType < 65 || BarcodeType > 73 || DataLength < 0) {
            LogManager.writeLog(E, "_barcodePrintDimension---parameter error,BarcodeType =" + BarcodeType + ",DataLength=" + DataLength);
            return 1002;
        }
        pszCommand[2] = (byte)BarcodeType;
        pszCommand[3] = (byte)DataLength;
        nReturn = this.WriteBuffer(pszCommand, 0, 4, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_barcodePrintDimension---out,nReturn = " + nReturn);
        if (nReturn == 4) {
            return 1000;
        }
        return 1042;
    }

    public int _barcodePrint2Dimension(int BarcodeType, int DataLength) {
        int nReturn = 0;
        byte[] byArray = new byte[4];
        byArray[0] = 29;
        byArray[1] = 107;
        byte[] pszCommand = byArray;
        LogManager.writeLog(D, "_barcodePrintDimension---enter,parameter:" + BarcodeType + "--" + DataLength);
        if (BarcodeType < 75 || BarcodeType > 78 || DataLength < 0) {
            LogManager.writeLog(E, "_barcodePrintDimension---parameter error,BarcodeType =" + BarcodeType + ",DataLength=" + DataLength);
            return 1002;
        }
        pszCommand[2] = (byte)BarcodeType;
        pszCommand[3] = (byte)DataLength;
        nReturn = this.WriteBuffer(pszCommand, 0, 4, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_barcodePrintDimension---out,nReturn = " + nReturn);
        if (nReturn == 4) {
            return 1000;
        }
        return 1043;
    }

    public int _barcodePrintGS1DataBar1Dimension(int BarcodeType, int BasicElementWidth, int BarcodeHeight, int BasicElementHeight, int SeparatorHeight, int SegmentHeight, int HRI, int AI) {
        int nReturn = 1000;
        LogManager.writeLog(D, "_barcodePrintGS1DataBar1Dimension---enter,parameter:" + BarcodeType + "--" + BasicElementWidth + BarcodeHeight + "--" + BasicElementHeight + "--" + SeparatorHeight + "--" + SegmentHeight + "--" + HRI + "--" + AI);
        if (BarcodeType < 1 || BarcodeType > 7 || BasicElementWidth < 1 || BasicElementWidth > 6 || BarcodeHeight < 2 || BarcodeHeight > 250 || BasicElementHeight < 1 || BasicElementHeight > 10 || SeparatorHeight < 1 || SeparatorHeight > 10 || SegmentHeight < 2 || SegmentHeight > 20 || HRI < 1 || HRI > 4 || AI < 0 || AI > 1) {
            LogManager.writeLog(E, "_barcodePrintGS1DataBar1Dimension---error,parameter:" + BarcodeType + "--" + BasicElementWidth + BarcodeHeight + "--" + BasicElementHeight + "--" + SeparatorHeight + "--" + SegmentHeight + "--" + HRI + "--" + AI);
            return 1002;
        }
        byte[] pszCommand = new byte[10];
        Arrays.fill(pszCommand, (byte)0);
        pszCommand[0] = 29;
        pszCommand[1] = 115;
        pszCommand[2] = (byte)BarcodeType;
        pszCommand[3] = (byte)BasicElementWidth;
        pszCommand[4] = (byte)BarcodeHeight;
        pszCommand[5] = (byte)SegmentHeight;
        pszCommand[6] = (byte)SeparatorHeight;
        pszCommand[7] = (byte)BasicElementHeight;
        pszCommand[8] = (byte)HRI;
        pszCommand[9] = (byte)AI;
        nReturn = this.WriteBuffer(pszCommand, 0, 10, 90000);
        pszCommand = null;
        LogManager.writeLog(D, "_barcodePrintGS1DataBar1Dimension---out,nReturn = " + nReturn);
        if (nReturn == 10) {
            return 1000;
        }
        return 1051;
    }

    public int _getGreyLevel(int pixel, float intensity) {
        float red = Color.red((int)pixel);
        float green = Color.green((int)pixel);
        float blue = Color.blue((int)pixel);
        float parcial = red + green + blue;
        int gray = (int)((parcial = (float)((double)parcial / 3.0)) * intensity);
        if (gray > 255) {
            gray = 255;
        }
        return gray;
    }

    public Bitmap _scaleImage(Bitmap picture, int newWidth) {
        int w1 = picture.getWidth();
        int h1 = picture.getHeight();
        int newHeight = newWidth * h1;
        Bitmap bm = Bitmap.createScaledBitmap((Bitmap)picture, (int)newWidth, (int)(newHeight /= w1), (boolean)false);
        return bm;
    }

    public Bitmap _imageInitWithUIImage(Bitmap image, int PrintAreaWidth) {
        this.m_Lock.lock();
        int image_height = image.getHeight();
        int image_width = image.getWidth();
        LogManager.writeLog(D, "_imageInitWithUIImage---enter,parameter:PrintAreaWidth=" + PrintAreaWidth + "--image.getWidth()=" + image.getWidth());
        if (image_width > PrintAreaWidth && PrintAreaWidth != 0) {
            int image_width_dest = PrintAreaWidth;
            int image_height_dest = (int)((double)image_height * (double)PrintAreaWidth / (double)image_width);
            Bitmap scale_image = Bitmap.createScaledBitmap((Bitmap)image, (int)image_width_dest, (int)image_height_dest, (boolean)false);
            LogManager.writeLog(D, "_imageInitWithUIImage---out,scale_image");
            this.m_Lock.unlock();
            return scale_image;
        }
        this.m_Lock.unlock();
        LogManager.writeLog(D, "_imageInitWithUIImage---out,image");
        Bitmap scale_image = Bitmap.createScaledBitmap((Bitmap)image, (int)image_width, (int)image_height, (boolean)false);
        return scale_image;
    }

    public int _imageFormatConvertForDownload(Bitmap cg_image, byte[] data_buf) {
        int image_h_src = 0;
        int image_w_src = 0;
        int image_row_bytes = 0;
        byte[] BitMask = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
        int img_height = 0;
        int img_width = 0;
        int Pixel_val = 0;
        int gray_val = 0;
        LogManager.writeLog(D, "_imageFormatConvertForDownload---enter");
        if (cg_image == null) {
            return 1002;
        }
        this.m_Lock.lock();
        image_h_src = cg_image.getHeight();
        image_w_src = cg_image.getWidth();
        img_width = image_h_src;
        img_height = (image_w_src + 31 >> 3 & 0xFFFFFFFC) << 3;
        image_row_bytes = img_width + 7 >> 3;
        int col_index_dest = img_width - 1;
        int row_index_src = image_h_src - 1;
        while (row_index_src >= 0) {
            byte mask_code = BitMask[col_index_dest & 7];
            int col_index_src = 0;
            while (col_index_src < image_w_src) {
                Pixel_val = cg_image.getPixel(col_index_src, row_index_src);
                gray_val = this._getGreyLevel(Pixel_val, 1.0f);
                if (gray_val < 127) {
                    int n = image_row_bytes * col_index_src + (col_index_dest >> 3);
                    data_buf[n] = (byte)(data_buf[n] | mask_code);
                }
                ++col_index_src;
            }
            --row_index_src;
            --col_index_dest;
        }
        this.m_Lock.unlock();
        LogManager.writeLog(D, "_imageFormatConvertForDownload---out");
        return 1000;
    }

    public int _imageDownloadToPrinterRAM(Bitmap cg_image, int nID) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 29;
        byArray[1] = 35;
        byte[] command_id_buf = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[0] = 29;
        byArray2[1] = 42;
        byte[] command_img_buf = byArray2;
        byte[] img_buf = null;
        int img_height = 0;
        int img_width = 0;
        int image_h_src = 0;
        int image_w_src = 0;
        int image_row_bytes = 0;
        int image_data_len = 0;
        int IMAGEHEIGHTMAX = 2040;
        LogManager.writeLog(D, "_imageDownloadToPrinterRAM---enter,parameter:nID=" + nID);
        if (nID < 0 || nID > 7) {
            LogManager.writeLog(E, "_imageDownloadToPrinterRAM --error,parameter,nID=" + nID);
            return 1002;
        }
        this.m_Lock.lock();
        image_h_src = cg_image.getHeight();
        image_w_src = cg_image.getWidth();
        if (image_h_src >= 2040) {
            this.m_Lock.unlock();
            LogManager.writeLog(E, "_imageDownloadToPrinterRAM --error,parameter,image_height=" + image_h_src);
            return 1002;
        }
        img_width = image_h_src;
        img_height = (image_w_src + 31 >> 3 & 0xFFFFFFFC) << 3;
        image_row_bytes = img_width + 7 >> 3;
        image_data_len = img_height * image_row_bytes;
        img_buf = new byte[image_data_len];
        Arrays.fill(img_buf, (byte)0);
        nReturn = this._imageFormatConvertForDownload(cg_image, img_buf);
        if (nReturn != 1000) {
            this.m_Lock.unlock();
            return 1029;
        }
        command_id_buf[2] = (byte)nID;
        nReturn = this.WriteBuffer(command_id_buf, 0, command_id_buf.length, 90000);
        if (nReturn != command_id_buf.length) {
            this.m_Lock.unlock();
            return 1029;
        }
        command_img_buf[2] = (byte)((byte)(img_height + 7 >> 3) & 0xFF);
        command_img_buf[3] = (byte)((byte)(img_width + 7 >> 3) & 0xFF);
        nReturn = this.WriteBuffer(command_img_buf, 0, command_img_buf.length, 90000);
        if (nReturn != command_img_buf.length) {
            this.m_Lock.unlock();
            return 1029;
        }
        nReturn = this.WriteBuffer(img_buf, 0, img_buf.length, 90000);
        LogManager.writeLog(D, "_imageDownloadToPrinterRAM---out, nReturn=" + nReturn);
        if (nReturn == img_buf.length) {
            img_buf = null;
            this.m_Lock.unlock();
            return 1000;
        }
        this.WriteBuffer(img_buf, nReturn, img_buf.length - nReturn, 90000);
        img_buf = null;
        this.m_Lock.unlock();
        return 1029;
    }

    public int _imageRAMPrint(int ImageID, int Mode) {
        int nReturn = 1000;
        byte[] byArray = new byte[6];
        byArray[0] = 29;
        byArray[1] = 35;
        byArray[3] = 29;
        byArray[4] = 47;
        byte[] command_buf = byArray;
        LogManager.writeLog(D, "_imageRAMPrint---enter,parameter" + ImageID + "--" + Mode);
        if (ImageID < 0 || ImageID > 7 || Mode < 0 || Mode > 3) {
            LogManager.writeLog(E, "_imageRAMPrint---parameter error,ImageID =" + ImageID + ",Mode=" + Mode);
            return 1002;
        }
        command_buf[2] = (byte)ImageID;
        command_buf[5] = (byte)Mode;
        nReturn = this.WriteBuffer(command_buf, 0, command_buf.length, 90000);
        LogManager.writeLog(D, "_imageRAMPrint---out, nReturn=" + nReturn);
        if (nReturn == command_buf.length) {
            command_buf = null;
            return 1000;
        }
        command_buf = null;
        return 1030;
    }

    public int _imagePrinterRAM(int nID, int nOrgx, int nMode) {
        int nReturn = 1000;
        LogManager.writeLog(D, "_imagePrinterRAM---enter,parameter" + nID + "--" + nOrgx + "--" + nMode);
        if (nID < 0 || nID > 7 || nOrgx < 0 || nOrgx > 65535 || nMode < 0 || nMode > 3) {
            LogManager.writeLog(E, "_imagePrinterRAM---parameter error,nID =" + nID + ",nOrgx=" + nOrgx + ",nMode" + nMode);
            return 1002;
        }
        this.m_Lock.lock();
        nReturn = this._standardModeSetHorStartingPosition(0, nOrgx);
        if (nReturn == 1001) {
            this.m_Lock.unlock();
            return nReturn;
        }
        nReturn = this._imageRAMPrint(nID, nMode);
        this.m_Lock.unlock();
        LogManager.writeLog(D, "_imagePrinterRAM---out, nReturn=" + nReturn);
        return nReturn;
    }

    public int _imageDownloadToPrinterFlash(int image_num, Bitmap[] cg_image) {
        int nReturn = 1000;
        byte[] byArray = new byte[3];
        byArray[0] = 28;
        byArray[1] = 113;
        byte[] command_buf = byArray;
        byte[] command_image_wh = new byte[4];
        byte[] img_buf = null;
        int image_h_src = 0;
        int image_w_src = 0;
        int image_row_bytes = 0;
        int img_height = 0;
        int img_width = 0;
        int image_data_len = 0;
        int IMAGEHEIGHTMAX = 2040;
        LogManager.writeLog(D, "_imageDownloadToPrinterFlash---enter,parameter,image_num=" + image_num);
        if (image_num < 0 || image_num > 255) {
            return 1002;
        }
        this.m_Lock.lock();
        command_buf[2] = (byte)image_num;
        nReturn = this.WriteBuffer(command_buf, 0, command_buf.length, 90000);
        if (nReturn != command_buf.length) {
            this.m_Lock.unlock();
            return 1001;
        }
        int image_index = 0;
        while (image_index < image_num) {
            image_h_src = cg_image[image_index].getHeight();
            image_w_src = cg_image[image_index].getWidth();
            if (image_h_src >= 2040) {
                LogManager.writeLog(E, "_imageDownloadToPrinterFlash --error,parameter,image_height=" + image_h_src);
                img_buf = null;
                this.m_Lock.unlock();
                return 1002;
            }
            img_width = image_h_src;
            img_height = (image_w_src + 31 >> 3 & 0xFFFFFFFC) << 3;
            image_row_bytes = img_width + 7 >> 3;
            image_data_len = img_height * image_row_bytes;
            img_buf = new byte[image_data_len];
            Arrays.fill(img_buf, (byte)0);
            nReturn = this._imageFormatConvertForDownload(cg_image[image_index], img_buf);
            if (nReturn != 1000) {
                this.m_Lock.unlock();
                img_buf = null;
                return nReturn;
            }
            int image_w_byte = img_height + 7 >> 3;
            int image_h_byte = img_width + 7 >> 3;
            command_image_wh[0] = (byte)(image_w_byte & 0xFF);
            command_image_wh[1] = (byte)(image_w_byte >> 8 & 0xFF);
            command_image_wh[2] = (byte)(image_h_byte & 0xFF);
            command_image_wh[3] = (byte)(image_h_byte >> 8 & 0xFF);
            nReturn = this.WriteBuffer(command_image_wh, 0, command_image_wh.length, 90000);
            if (nReturn != command_image_wh.length) {
                img_buf = null;
                this.m_Lock.unlock();
                return 1031;
            }
            nReturn = this.WriteBuffer(img_buf, 0, img_buf.length, 90000);
            if (nReturn != img_buf.length) {
                this.WriteBuffer(img_buf, nReturn, img_buf.length - nReturn, 90000);
                img_buf = null;
                this.m_Lock.unlock();
                return 1031;
            }
            img_buf = null;
            ++image_index;
        }
        this.m_Lock.unlock();
        LogManager.writeLog(D, "_imagePrinterRAM---out");
        return 1000;
    }

    public int _imageFlashPrint(int ImageID, int Mode) {
        int nReturn = 1000;
        byte[] byArray = new byte[4];
        byArray[0] = 28;
        byArray[1] = 112;
        byte[] command_buf = byArray;
        LogManager.writeLog(D, "_imageFlashPrint --enter,parameter:" + ImageID + "--" + Mode);
        if (ImageID < 0 || ImageID > 255) {
            LogManager.writeLog(E, "_imageFlashPrint --parameter error,parameter:nID= " + ImageID);
            return 1002;
        }
        command_buf[2] = (byte)ImageID;
        command_buf[3] = (byte)Mode;
        nReturn = this.WriteBuffer(command_buf, 0, command_buf.length, 90000);
        LogManager.writeLog(D, "_imagePrinterRAM---out,nReturn =" + nReturn);
        if (nReturn == command_buf.length) {
            command_buf = null;
            return 1000;
        }
        command_buf = null;
        return 1032;
    }

    public int _imageDownLoadAndPrint(Bitmap image, int Mode, int StartHorPos) {
        int nReturn = 1000;
        byte[] BitMask1 = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
        byte[] byArray = new byte[3];
        byArray[0] = 27;
        byArray[1] = 51;
        byte[] command_line_height = byArray;
        byte[] pszCommand = new byte[]{27, 50};
        byte[] byArray2 = new byte[5];
        byArray2[0] = 27;
        byArray2[1] = 42;
        byte[] command_buf = byArray2;
        byte[] feed_line_command = new byte[]{10};
        byte[] image_block_dest = null;
        int block_height = 0;
        LogManager.writeLog(D, "_imageDownLoadAndPrint---enter,parameter,SingleDoubleFlag=" + Mode + ",StartHorPos" + StartHorPos);
        this.m_Lock.lock();
        int image_h_src = image.getHeight();
        int image_w_src = image.getWidth();
        if (Mode == 0) {
            command_buf[2] = 0;
            block_height = 8;
        } else if (Mode == 1) {
            command_buf[2] = 1;
            block_height = 8;
        } else if (Mode == 32) {
            command_buf[2] = 32;
            block_height = 24;
        } else if (Mode == 33) {
            command_buf[2] = 33;
            block_height = 24;
        }
        command_line_height[2] = (byte)block_height;
        int row_bytes_src = (image_w_src + 31) / 32 * 4;
        int image_w_dest = row_bytes_src << 3;
        int image_h_dest = (image_h_src + (block_height - 1)) / block_height * block_height;
        command_buf[3] = (byte)(image_w_dest & 0xFF);
        command_buf[4] = (byte)(image_w_dest >> 8);
        image_block_dest = new byte[row_bytes_src * block_height];
        Arrays.fill(image_block_dest, (byte)0);
        nReturn = this.WriteBuffer(command_line_height, 0, 3, 90000);
        if (nReturn != 3) {
            image_block_dest = null;
            this.m_Lock.unlock();
            return 1028;
        }
        int row = 0;
        while (row < image_h_dest) {
            nReturn = this._standardModeSetHorStartingPosition(0, StartHorPos);
            if (nReturn != 1000) {
                image_block_dest = null;
                this.m_Lock.unlock();
                return 1028;
            }
            nReturn = this.WriteBuffer(command_buf, 0, 5, 90000);
            if (nReturn != 5) {
                image_block_dest = null;
                this.m_Lock.unlock();
                return 1028;
            }
            Arrays.fill(image_block_dest, (byte)0);
            int row_up = row + block_height <= image_h_src ? block_height - 1 : image_h_src % block_height - 1;
            int col = 0;
            while (col < image_w_src) {
                int index = row_up;
                while (index >= 0) {
                    int Pixel_val = image.getPixel(col, row + index);
                    int gray_val = this._getGreyLevel(Pixel_val, 1.0f);
                    if (gray_val < 127) {
                        int n = col * (block_height >> 3) + (index >> 3);
                        image_block_dest[n] = (byte)(image_block_dest[n] | BitMask1[index & 7]);
                    }
                    --index;
                }
                ++col;
            }
            nReturn = this.WriteBuffer(image_block_dest, 0, row_bytes_src * block_height, 90000);
            if (nReturn != row_bytes_src * block_height) {
                image_block_dest = null;
                this.m_Lock.unlock();
                return 1028;
            }
            nReturn = this.WriteBuffer(feed_line_command, 0, 1, 90000);
            row += block_height;
        }
        image_block_dest = null;
        this.WriteBuffer(pszCommand, 0, 2, 90000);
        this.m_Lock.unlock();
        LogManager.writeLog(D, "_imageDownLoadAndPrint---out");
        return 1000;
    }

    public int _imageStandardModeRasterPrint(Bitmap cg_image) {
        int nReturn = 1000;
        int image_width = 0;
        int image_height = 0;
        byte[] beginingBytes = new byte[]{27, 64, 29, 68, 1};
        byte[] byArray = new byte[2];
        byArray[0] = 22;
        byte[] imagestarting = byArray;
        byte[] BitMask1 = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
        byte[] imageData4 = new byte[]{21, 1};
        byte[] byArray2 = new byte[3];
        byArray2[0] = 29;
        byArray2[1] = 68;
        byte[] imageData5 = byArray2;
        byte[] data = null;
        byte[] des_buf = null;
        int des_pos = 0;
        int IMAGEHEIGHTMAX = 2040;
        LogManager.writeLog(D, "_imageStandardModeRasterPrint---enter");
        this.m_Lock.lock();
        image_height = cg_image.getHeight();
        image_width = cg_image.getWidth();
        if (image_height > 2040 && image_width > 2040) {
            this.m_Lock.unlock();
            return 1002;
        }
        int bytes_per_line = image_width + 7 >> 3;
        int last_byte_bits = image_width & 7;
        imagestarting[1] = (byte)bytes_per_line;
        nReturn = this.WriteBuffer(beginingBytes, 0, beginingBytes.length, 90000);
        if (nReturn != beginingBytes.length) {
            this.m_Lock.unlock();
            return 1033;
        }
        data = new byte[bytes_per_line];
        des_buf = new byte[(bytes_per_line + imagestarting.length + imageData4.length) * image_height];
        int y = 0;
        while (y < image_height) {
            System.arraycopy(imagestarting, 0, des_buf, des_pos, imagestarting.length);
            des_pos += imagestarting.length;
            Arrays.fill(data, (byte)0);
            int x = 0;
            while (x < bytes_per_line) {
                int cur_byte_bits = x == bytes_per_line - 1 ? last_byte_bits : 8;
                int xbit = 0;
                while (xbit < cur_byte_bits) {
                    int Pixel_val = cg_image.getPixel(x * 8 + xbit, y);
                    int gray_val = this._getGreyLevel(Pixel_val, 1.0f);
                    if (gray_val < 127) {
                        int n = x;
                        data[n] = (byte)(data[n] | BitMask1[xbit]);
                    }
                    ++xbit;
                }
                ++x;
            }
            System.arraycopy(data, 0, des_buf, des_pos, data.length);
            System.arraycopy(imageData4, 0, des_buf, des_pos += data.length, imageData4.length);
            des_pos += imageData4.length;
            ++y;
        }
        nReturn = this.WriteBuffer(des_buf, 0, des_buf.length, 90000);
        if (nReturn != des_buf.length) {
            nReturn = this.WriteBuffer(des_buf, nReturn, des_buf.length - nReturn, 90000);
            this.WriteBuffer(imageData5, 0, imageData5.length, 90000);
            data = null;
            des_buf = null;
            this.m_Lock.unlock();
            return 1033;
        }
        nReturn = this.WriteBuffer(imageData5, 0, imageData5.length, 90000);
        if (nReturn != imageData5.length) {
            data = null;
            des_buf = null;
            this.m_Lock.unlock();
            return 1033;
        }
        this.m_Lock.unlock();
        data = null;
        LogManager.writeLog(D, "_imageStandardModeRasterPrint---out");
        return 1000;
    }

    public Bitmap _createRasterBitmap(String printText, int textSize, int bold) {
        Typeface typeface;
        int printableArea = 576;
        if (bold < 1 || bold > 5 || textSize < 1 || textSize > 200) {
            return null;
        }
        this.m_Lock.lock();
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(-16777216);
        paint.setAntiAlias(true);
        try {
            typeface = Typeface.create((Typeface)Typeface.SERIF, (int)bold);
        }
        catch (Exception e) {
            typeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)bold);
        }
        paint.setTypeface(typeface);
        paint.setTextSize((float)(textSize * 2));
        paint.setLinearText(true);
        TextPaint textpaint = new TextPaint(paint);
        textpaint.setLinearText(true);
        StaticLayout staticLayout = new StaticLayout((CharSequence)printText, textpaint, printableArea, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        int height = staticLayout.getHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)staticLayout.getWidth(), (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas c = new Canvas(bitmap);
        c.drawColor(-1);
        c.translate(0.0f, 0.0f);
        staticLayout.draw(c);
        this.m_Lock.unlock();
        return bitmap;
    }

    public String byte2hex(byte[] buffer) {
        String h = "";
        int i = 0;
        while (i < buffer.length) {
            String temp = Integer.toHexString(buffer[i] & 0xFF);
            if (temp.length() == 1) {
                temp = "0" + temp;
            }
            h = String.valueOf(h) + " " + temp;
            ++i;
        }
        return h;
    }

    private char[] getChars(byte[] bytes) {
        Charset cs = Charset.forName("UTF-8");
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        bb.put(bytes);
        bb.flip();
        CharBuffer cb = cs.decode(bb);
        return cb.array();
    }
}

