/*
 * Decompiled with CFR 0.152.
 */
package POSSDK;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class LogManager {
    private static final String LOG_TAG = "WriteLog";
    private static boolean sdCardCanWrite = false;
    private static String pathOfSDCard;
    private static final int MAX_FILE_LENGTH = 0x500000;
    public static String FILE_NAME;
    private static long LocalSpace;
    private static boolean LocalCanWrite;
    private static Context context;
    private static String LocalFilePath;

    static {
        LocalCanWrite = false;
    }

    private LogManager() {
    }

    public static long getAvailableInternalMemorySize() {
        File path = Environment.getDataDirectory();
        Log.d((String)LOG_TAG, (String)("path=" + path.getPath()));
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        long availableBlocks = stat.getAvailableBlocks();
        return availableBlocks * blockSize;
    }

    public static void init(Context contexts, String log_file_name) {
        context = contexts;
        FILE_NAME = log_file_name;
        if (Environment.getExternalStorageState().equals("mounted")) {
            sdCardCanWrite = true;
            LocalCanWrite = false;
            Log.d((String)LOG_TAG, (String)"SD\u5361\u5df2\u6302\u5728\uff0c\u5e76\u4e14\u53ef\u4ee5\u8bfb\u5199");
        } else {
            sdCardCanWrite = false;
            LocalCanWrite = true;
            Log.d((String)LOG_TAG, (String)"SD\u5361\u4e0d\u5b58\u5728");
        }
        if (sdCardCanWrite) {
            pathOfSDCard = Environment.getExternalStorageDirectory().getAbsolutePath();
            Log.d((String)LOG_TAG, (String)("SD\u5361\u8def\u5f84\u4e3a\uff1a" + pathOfSDCard));
        }
        if (sdCardCanWrite) {
            StatFs statfs = new StatFs(pathOfSDCard);
            long nSDFreeSize = statfs.getAvailableBlocks() * statfs.getBlockSize();
            Log.d((String)LOG_TAG, (String)("SD\u5361\u5269\u4f59\u5bb9\u91cf\uff08byte\uff09\uff1a" + nSDFreeSize));
            if (nSDFreeSize < 0x500000L) {
                sdCardCanWrite = false;
                Log.d((String)LOG_TAG, (String)"SD\u5361\u5269\u4f59\u5bb9\u91cf\u8fc7\u5c0f\uff0c\u505c\u6b62\u5199\u65e5\u5fd7\u3002");
            }
        } else {
            LocalSpace = LogManager.getAvailableInternalMemorySize();
            Log.d((String)LOG_TAG, (String)("\u624b\u673a\u5185\u5b58\u5269\u4f59\u5bb9\u91cf\u4e3a\uff1a" + LocalSpace));
            LocalFilePath = context.getFilesDir().getAbsolutePath();
            Log.d((String)LOG_TAG, (String)("\u624b\u673a\u5185\u5b58\u65e5\u5fd7\u6587\u4ef6\u8def\u5f84\uff1a" + LocalFilePath));
            if (LocalSpace < 0x100000L) {
                Log.d((String)LOG_TAG, (String)"\u624b\u673a\u5185\u5b58\u5269\u4f59\u5bb9\u91cf\u8fc7\u5c0f\uff0c\u505c\u6b62\u5199\u65e5\u5fd7\u3002");
                LocalCanWrite = false;
            }
        }
    }

    public static boolean writeLog(String level, String message) {
        boolean result = true;
        if (!(level.equals("V") || level.equals("D") || level.equals("I") || level.equals("W") || level.equals("E"))) {
            return false;
        }
        if (message.length() == 0) {
            return false;
        }
        if (sdCardCanWrite) {
            File myFile = new File(String.valueOf(pathOfSDCard) + File.separator + FILE_NAME);
            if (myFile.exists()) {
                try {
                    long size = myFile.length();
                    if (size > 0x500000L) {
                        myFile.delete();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = false;
                }
            }
            try {
                FileWriter fw = new FileWriter(String.valueOf(pathOfSDCard) + File.separator + FILE_NAME, true);
                Calendar calendar = Calendar.getInstance();
                Date d = calendar.getTime();
                fw.write(String.valueOf(level) + "--" + d.toGMTString() + message + "\n");
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                result = false;
            }
        } else if (LocalCanWrite) {
            File myFile = new File(String.valueOf(LocalFilePath) + File.separator + FILE_NAME);
            if (myFile.exists()) {
                try {
                    long size = myFile.length();
                    if (size > 0x100000L) {
                        myFile.delete();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = false;
                }
            }
            if (!myFile.exists()) {
                LogManager.create();
            }
            Calendar calendar = Calendar.getInstance();
            Date d = calendar.getTime();
            LogManager.write(String.valueOf(level) + "--" + d.toGMTString() + message + "\n");
        }
        return result;
    }

    private static boolean isExist() {
        String[] fileNameArray = context.fileList();
        int i = 0;
        while (i < fileNameArray.length) {
            if (fileNameArray[i].equals(FILE_NAME)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean create() {
        boolean result = false;
        if (!LogManager.isExist()) {
            FileOutputStream fos = null;
            try {
                fos = context.openFileOutput(FILE_NAME, 1);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            if (fos != null) {
                result = true;
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static boolean write(String str) {
        boolean result = true;
        FileOutputStream fos = null;
        if (LogManager.isExist()) {
            try {
                fos = context.openFileOutput(FILE_NAME, 32768);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                result = false;
            }
            byte[] bt = (String.valueOf(str) + "\n").getBytes();
            if (fos != null) {
                try {
                    fos.write(bt);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    result = false;
                }
                try {
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = false;
                }
            }
        }
        return result;
    }
}

