/*
 * Decompiled with CFR 0.152.
 */
package POSAPI;

import POSAPI.POSInterfaceAPI;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.ParcelFileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.HashMap;

public class POSUSBAPI
extends POSInterfaceAPI {
    private Context mActivity;
    private static final String LOG_TAG = "SNBC_POS";
    public static final int POS_SUCCESS = 1000;
    public static final int ERR_PROCESSING = 1001;
    public static final int WRITEBYTEMAX = 4096;
    private static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";
    public UsbManager mUsbManager;
    private PendingIntent mPermissionIntent;
    private boolean mPermissionRequestPending;
    public UsbAccessory mAccessory;
    ParcelFileDescriptor mFileDescriptor;
    FileOutputStream mOutputStream;
    FileInputStream mInputStream;
    private UsbDevice device = null;
    private UsbDevice des_dev = null;
    private UsbDeviceConnection connection = null;
    private boolean request_flag = true;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            UsbAccessory accessory;
            String action = intent.getAction();
            if (POSUSBAPI.ACTION_USB_PERMISSION.equals(action)) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    POSUSBAPI.this.device = (UsbDevice)intent.getParcelableExtra("accessory");
                    intent.getBooleanExtra("permission", false);
                    POSUSBAPI.this.mPermissionRequestPending = false;
                }
            } else if ("android.hardware.usb.action.USB_ACCESSORY_DETACHED".equals(action) && (accessory = (UsbAccessory)intent.getParcelableExtra("accessory")) != null) {
                accessory.equals((Object)POSUSBAPI.this.mAccessory);
            }
        }
    };

    public POSUSBAPI(Context activity) {
        this.mActivity = activity;
        this.mUsbManager = (UsbManager)activity.getSystemService("usb");
        boolean dev_id = false;
        HashMap deviceList = this.mUsbManager.getDeviceList();
        for (UsbDevice this.device : deviceList.values()) {
            if (this.device.getVendorId() == 5455 || this.device.getVendorId() == 1008) break;
        }
    }

    @Override
    public int OpenDevice() {
        if (this.device == null && this.request_flag && this.des_dev == null) {
            this.mUsbManager = (UsbManager)this.mActivity.getSystemService("usb");
            HashMap deviceList = this.mUsbManager.getDeviceList();
            for (UsbDevice this.device : deviceList.values()) {
                if (this.device.getVendorId() == 5455 || this.device.getVendorId() == 1008) break;
            }
            if (this.device == null) {
                return 1001;
            }
        }
        Context activity = this.mActivity;
        this.mPermissionIntent = PendingIntent.getBroadcast((Context)activity, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
        activity.registerReceiver(this.mUsbReceiver, filter);
        if (this.request_flag && this.device != null) {
            this.des_dev = this.device;
            this.mUsbManager.requestPermission(this.device, this.mPermissionIntent);
            this.request_flag = false;
        }
        if (this.des_dev != null) {
            this.connection = this.mUsbManager.openDevice(this.des_dev);
            if (this.connection != null) {
                return 1000;
            }
            this.request_flag = true;
            this.des_dev = null;
            return 1001;
        }
        this.request_flag = true;
        return 1001;
    }

    @Override
    public int OpenDevice(int Vid, int Pid) {
        boolean flag = false;
        this.mUsbManager = (UsbManager)this.mActivity.getSystemService("usb");
        HashMap deviceList = this.mUsbManager.getDeviceList();
        for (UsbDevice this.device : deviceList.values()) {
            if (this.device.getVendorId() != Vid || this.device.getProductId() != Pid) continue;
            flag = true;
            break;
        }
        if (this.device == null || !flag) {
            return 1001;
        }
        Context activity = this.mActivity;
        this.mPermissionIntent = PendingIntent.getBroadcast((Context)activity, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
        activity.registerReceiver(this.mUsbReceiver, filter);
        if (flag && this.device != null) {
            this.des_dev = this.device;
            this.mUsbManager.requestPermission(this.device, this.mPermissionIntent);
            flag = false;
        }
        if (this.des_dev != null) {
            this.connection = this.mUsbManager.openDevice(this.des_dev);
            if (this.connection != null) {
                return 1000;
            }
            this.des_dev = null;
            return 1001;
        }
        return 1001;
    }

    @Override
    public int WriteBuffer(byte[] WriteBuffer, int OffsetSize, int nBytesToWrite, int WriteTimeOut) {
        int write_size = 0;
        int i = 0;
        boolean k = false;
        int res_len = 0;
        int mode_len = 0;
        int count = 0;
        long tick = 0L;
        long totulTick = 0L;
        byte[] temp_buf = null;
        if (this.des_dev == null || this.connection == null || WriteBuffer == null || nBytesToWrite <= 0 || OffsetSize < 0) {
            return 0;
        }
        UsbInterface intf = this.des_dev.getInterface(0);
        UsbEndpoint endpoint = intf.getEndpoint(0);
        boolean forceClaim = true;
        this.connection.claimInterface(intf, forceClaim);
        tick = System.currentTimeMillis();
        totulTick = tick + (long)WriteTimeOut;
        byte[] des_buf = new byte[nBytesToWrite];
        Arrays.fill(des_buf, (byte)0);
        if (OffsetSize + nBytesToWrite > WriteBuffer.length) {
            des_buf = null;
            return 0;
        }
        System.arraycopy(WriteBuffer, OffsetSize, des_buf, 0, nBytesToWrite);
        if (des_buf.length > 4096) {
            temp_buf = new byte[4096];
            Arrays.fill(temp_buf, (byte)0);
            mode_len = des_buf.length / 4096;
            res_len = des_buf.length % 4096;
            count = 0;
            while (count < mode_len) {
                tick = System.currentTimeMillis();
                if (tick > totulTick) {
                    temp_buf = null;
                    des_buf = null;
                    return count * 4096;
                }
                System.arraycopy(des_buf, count * 4096 + i, temp_buf, 0, 4096);
                write_size = this.connection.bulkTransfer(endpoint, temp_buf, 4096, WriteTimeOut);
                if (write_size != 4096) {
                    temp_buf = null;
                    des_buf = null;
                    return count * 4096;
                }
                ++count;
            }
            if (res_len != 0) {
                i = 0;
                while (i < res_len) {
                    temp_buf[i] = des_buf[mode_len * 4096 + i];
                    ++i;
                }
                write_size = this.connection.bulkTransfer(endpoint, temp_buf, res_len, WriteTimeOut);
                if (write_size == res_len) {
                    temp_buf = null;
                    des_buf = null;
                    return nBytesToWrite;
                }
                temp_buf = null;
                des_buf = null;
                return 0;
            }
            temp_buf = null;
            des_buf = null;
            return nBytesToWrite;
        }
        write_size = this.connection.bulkTransfer(endpoint, des_buf, nBytesToWrite, WriteTimeOut);
        if (write_size == nBytesToWrite) {
            temp_buf = null;
            des_buf = null;
            return nBytesToWrite;
        }
        temp_buf = null;
        des_buf = null;
        return 0;
    }

    @Override
    public int ReadBuffer(byte[] ReadBuffer, int OffsetSize, int nBytesToRead, int ReadTimeOut) {
        int read_size = 0;
        int i = 0;
        if (this.des_dev == null || this.connection == null) {
            return 0;
        }
        UsbInterface intf = this.des_dev.getInterface(0);
        UsbEndpoint endpoint = intf.getEndpoint(2);
        boolean forceClaim = true;
        this.connection.claimInterface(intf, forceClaim);
        byte[] temp_buf = new byte[ReadBuffer.length];
        read_size = this.connection.bulkTransfer(endpoint, temp_buf, nBytesToRead, ReadTimeOut);
        read_size = this.connection.bulkTransfer(endpoint, temp_buf, nBytesToRead, ReadTimeOut);
        read_size = this.connection.bulkTransfer(endpoint, temp_buf, nBytesToRead, ReadTimeOut);
        if (read_size > 0) {
            i = OffsetSize;
            while (i < OffsetSize + read_size) {
                ReadBuffer[i] = temp_buf[i - OffsetSize];
                ++i;
            }
            temp_buf = null;
            return read_size;
        }
        temp_buf = null;
        return 0;
    }

    @Override
    public int ReadBuffer(byte[] ReadBuffer, int OffsetSize, int nBytesToRead, int ReadTimeOut, int PortNum) {
        int read_size = 0;
        int i = 0;
        if (this.des_dev == null || this.connection == null && PortNum > 0 && PortNum < 3) {
            return 0;
        }
        UsbInterface intf = this.des_dev.getInterface(0);
        UsbEndpoint endpoint = intf.getEndpoint(PortNum);
        boolean forceClaim = true;
        this.connection.claimInterface(intf, forceClaim);
        byte[] temp_buf = new byte[ReadBuffer.length];
        if (PortNum == 1) {
            read_size = this.connection.bulkTransfer(endpoint, temp_buf, nBytesToRead, ReadTimeOut);
        } else {
            read_size = this.connection.bulkTransfer(endpoint, temp_buf, nBytesToRead, ReadTimeOut);
            read_size = this.connection.bulkTransfer(endpoint, temp_buf, nBytesToRead, ReadTimeOut);
        }
        if (read_size > 0) {
            i = OffsetSize;
            while (i < OffsetSize + read_size) {
                ReadBuffer[i] = temp_buf[i - OffsetSize];
                ++i;
            }
            temp_buf = null;
            return read_size;
        }
        temp_buf = null;
        return 0;
    }

    @Override
    public int CloseDevice() {
        Context activity = this.mActivity;
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
            activity.unregisterReceiver(this.mUsbReceiver);
        }
        return 1000;
    }

    public String byte2hex(byte[] buffer) {
        String h = "";
        int i = 0;
        while (i < buffer.length) {
            String temp = Integer.toHexString(buffer[i] & 0xFF);
            if (temp.length() == 1) {
                temp = "0" + temp;
            }
            h = String.valueOf(h) + " " + temp;
            ++i;
        }
        return h;
    }
}

