/*
 * Decompiled with CFR 0.152.
 */
package POSAPI;

import POSAPI.POSInterfaceAPI;
import android.os.SystemClock;
import android_serialport_api.SerialPort;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public class POSSerialAPI
extends POSInterfaceAPI {
    public SerialPort mSerialport;
    private static final String LOG_TAG = "SNBC_COM_POS";
    public static final int POS_SUCCESS = 1000;
    public static final int ERR_PROCESSING = 1001;
    public static final int POS_FAIL = 1002;
    public static final int WRITEBYTEMAX = 4096;
    public static final int READBYTEMAX = 1024;
    private boolean ThreadFlg = false;

    @Override
    public int OpenDevice(File device, int baudrate) {
        try {
            this.mSerialport = new SerialPort(device, baudrate, 0);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.mSerialport == null) {
            return 1001;
        }
        return 1000;
    }

    @Override
    public int WriteBuffer(byte[] WriteBuffer, int OffsetSize, int nBytesToWrite, int WriteTimeOut) {
        int i = 0;
        int res_len = 0;
        int mode_len = 0;
        int count = 0;
        long tick = 0L;
        long totulTick = 0L;
        byte[] temp_buf = null;
        byte[] res_buf = null;
        if (WriteBuffer == null || nBytesToWrite <= 0 || OffsetSize < 0 || this.mSerialport == null) {
            return 0;
        }
        tick = System.currentTimeMillis();
        totulTick = tick + (long)WriteTimeOut;
        byte[] des_buf = new byte[nBytesToWrite];
        Arrays.fill(des_buf, (byte)0);
        if (OffsetSize + nBytesToWrite > WriteBuffer.length) {
            des_buf = null;
            return 0;
        }
        System.arraycopy(WriteBuffer, OffsetSize, des_buf, 0, nBytesToWrite);
        if (des_buf.length > 4096) {
            temp_buf = new byte[4096];
            Arrays.fill(temp_buf, (byte)0);
            mode_len = des_buf.length / 4096;
            res_len = des_buf.length % 4096;
            count = 0;
            while (count < mode_len) {
                tick = System.currentTimeMillis();
                if (tick > totulTick) {
                    temp_buf = null;
                    des_buf = null;
                    return count * 4096;
                }
                System.arraycopy(des_buf, count * 4096 + i, temp_buf, 0, 4096);
                try {
                    this.mSerialport.getOutputStream().write(temp_buf);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    temp_buf = null;
                    des_buf = null;
                    return count * 4096;
                }
                ++count;
            }
            if (res_len != 0) {
                res_buf = new byte[res_len];
                i = 0;
                while (i < res_len) {
                    res_buf[i] = des_buf[mode_len * 4096 + i];
                    ++i;
                }
                try {
                    this.mSerialport.getOutputStream().write(res_buf);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    temp_buf = null;
                    res_buf = null;
                    des_buf = null;
                    return 0;
                }
            }
        } else {
            try {
                this.mSerialport.getOutputStream().write(des_buf);
            }
            catch (IOException e) {
                e.printStackTrace();
                temp_buf = null;
                res_buf = null;
                des_buf = null;
                return 0;
            }
        }
        temp_buf = null;
        res_buf = null;
        des_buf = null;
        return nBytesToWrite;
    }

    @Override
    public int ReadBuffer(byte[] ReadBuffer, int OffsetSize, int nBytesToRead, int ReadTimeOut) {
        int read_size = 1000;
        int i = 0;
        ReadInput read_thread = new ReadInput();
        if (this.mSerialport == null || nBytesToRead < 1) {
            return 0;
        }
        byte[] temp_buf = new byte[1024];
        if (!this.ThreadFlg) {
            read_thread.start();
            long tick = System.currentTimeMillis();
            long totulTick = tick + (long)ReadTimeOut;
            while (!read_thread.isread()) {
                SystemClock.sleep((long)500L);
                tick = System.currentTimeMillis();
                if (totulTick < tick) break;
            }
            if (read_thread.isread()) {
                read_size = read_thread.getlen();
                temp_buf = read_thread.gettemp();
            } else {
                this.ThreadFlg = false;
                return 0;
            }
        }
        if (read_size > 0) {
            i = OffsetSize;
            while (i < OffsetSize + read_size) {
                ReadBuffer[i] = temp_buf[i - OffsetSize];
                ++i;
            }
            return read_size;
        }
        return 0;
    }

    @Override
    public int CloseDevice() {
        if (this.mSerialport != null) {
            this.mSerialport.close();
            this.mSerialport = null;
        }
        return 1000;
    }

    private class ReadInput
    extends Thread {
        private boolean isread = false;
        private int len;
        private byte[] temp = new byte[1024];

        private ReadInput() {
        }

        @Override
        public void run() {
            super.run();
            POSSerialAPI.this.ThreadFlg = true;
            try {
                this.len = POSSerialAPI.this.mSerialport.getInputStream().read(this.temp);
            }
            catch (IOException e) {
                this.isread = false;
                e.printStackTrace();
            }
            this.isread = true;
            POSSerialAPI.this.ThreadFlg = false;
        }

        public boolean isread() {
            return this.isread;
        }

        public int getlen() {
            return this.len;
        }

        public byte[] gettemp() {
            return this.temp;
        }
    }
}

