/*
 * Decompiled with CFR 0.152.
 */
package POSAPI;

import POSAPI.POSInterfaceAPI;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;

public class POSBluetoothAPI
extends POSInterfaceAPI {
    private Context context;
    public static final int POS_SUCCESS = 1000;
    public static final int ERR_PROCESSING = 1001;
    public static final int POS_FAIL = 1002;
    public static final int WRITEBYTEMAX = 4096;
    public static final int READBYTEMAX = 1024;
    private boolean ThreadFlg = false;
    private static final UUID uuid = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    public static final int STATE_ON = 12;
    public static final int STATE_OFF = 10;
    public static final int STATE_TURNING_ON = 11;
    public static final int STATE_TURNING_OFF = 13;
    public static final int STATE_NONE = 200;
    public static final int STATE_LISTEN = 201;
    public static final int STATE_CONNECTING = 202;
    public static final int STATE_CONNECTED = 203;
    private int connectState;
    private boolean btSupport;
    private BluetoothAdapter btAdapter;
    private BluetoothDevice btDevice;
    private BluetoothSocket btSocket;
    private InputStream is = null;
    private OutputStream os = null;
    private static final String LOG_TAG = "SNBC_POS";
    private static POSBluetoothAPI bluetoothManager = null;
    private byte[] mTempData = null;
    private int mReadbyte = 0;
    private Boolean mBExceptionBoolean = false;
    public static final int READTIMEOUT = 90000;
    private int mTimeout = 3000;
    protected int mTimeAfterRead = 100;

    POSBluetoothAPI(Context context) {
        this.context = context;
        this.btAdapter = BluetoothAdapter.getDefaultAdapter();
        this.btSupport = this.btAdapter != null;
        this.setConnectState(200);
    }

    public static synchronized POSBluetoothAPI getInstance(Context context) {
        if (bluetoothManager == null) {
            bluetoothManager = new POSBluetoothAPI(context);
        }
        return bluetoothManager;
    }

    public boolean isBTSupport() {
        return this.btSupport;
    }

    public String getAddress() {
        if (this.btAdapter != null) {
            return this.btAdapter.getAddress();
        }
        return null;
    }

    public String getName() {
        if (this.btAdapter != null) {
            return this.btAdapter.getName();
        }
        return null;
    }

    public int getState() {
        if (this.btAdapter != null) {
            return this.btAdapter.getState();
        }
        return 10;
    }

    private void setConnectState(int state) {
        this.connectState = state;
    }

    public int getConnectState() {
        return this.connectState;
    }

    public boolean openBluetooth() {
        boolean result = true;
        try {
            if (this.btAdapter == null) {
                result = false;
            }
            if (!this.btAdapter.isEnabled()) {
                Intent enableIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
                this.context.startActivity(enableIntent);
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean closeBluetooth() {
        boolean result = true;
        try {
            if (this.btAdapter != null && this.btAdapter.isEnabled()) {
                this.btAdapter.disable();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public boolean setDiscoverable(int time) {
        if (time <= 0 || time > 300) {
            Log.e((String)LOG_TAG, (String)("setDiscoverable error time:" + time));
            return false;
        }
        boolean result = true;
        if (this.btAdapter != null) {
            Intent discoverableIntent = new Intent("android.bluetooth.adapter.action.REQUEST_DISCOVERABLE");
            discoverableIntent.putExtra("android.bluetooth.adapter.extra.DISCOVERABLE_DURATION", time);
            this.context.startActivity(discoverableIntent);
        } else {
            result = false;
        }
        return result;
    }

    public boolean startDiscovery() {
        boolean result = true;
        if (this.btAdapter != null && this.btAdapter.getState() == 12) {
            if (this.btAdapter.isDiscovering()) {
                this.btAdapter.cancelDiscovery();
            }
            result = this.btAdapter.startDiscovery();
        } else {
            result = false;
        }
        return result;
    }

    public boolean isDiscovery() {
        return this.btAdapter.isDiscovering();
    }

    public boolean cancelDiscovery() {
        boolean result = false;
        if (this.btAdapter.isDiscovering()) {
            result = this.btAdapter.cancelDiscovery();
        }
        return result;
    }

    public Set<BluetoothDevice> getBondedDevices() {
        if (this.btAdapter != null) {
            return this.btAdapter.getBondedDevices();
        }
        return null;
    }

    @Override
    public int OpenDevice(String macAddress) {
        if (this.btAdapter == null) {
            return 1001;
        }
        if (!BluetoothAdapter.checkBluetoothAddress((String)macAddress)) {
            return 1001;
        }
        this.btDevice = this.btAdapter.getRemoteDevice(macAddress);
        try {
            this.btSocket = this.btDevice.createRfcommSocketToServiceRecord(uuid);
            this.btSocket.connect();
            this.setConnectState(203);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1001;
        }
        return 1000;
    }

    @Override
    public int CloseDevice() {
        int result = 1000;
        if (this.btDevice != null) {
            this.btDevice = null;
        }
        try {
            if (this.btSocket != null) {
                this.btSocket.close();
            }
            this.setConnectState(200);
        }
        catch (IOException e) {
            result = 1001;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public int WriteBuffer(byte[] WriteBuffer, int OffsetSize, int nBytesToWrite, int WriteTimeOut) {
        int i = 0;
        int res_len = 0;
        int mode_len = 0;
        int count = 0;
        long tick = 0L;
        long totulTick = 0L;
        byte[] temp_buf = null;
        byte[] res_buf = null;
        if (WriteBuffer == null || nBytesToWrite <= 0 || OffsetSize < 0) {
            return 0;
        }
        if (this.getState() == 10) {
            return 0;
        }
        tick = System.currentTimeMillis();
        totulTick = tick + (long)WriteTimeOut;
        try {
            this.os = this.btSocket.getOutputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        if (this.os == null) {
            return 0;
        }
        byte[] des_buf = new byte[nBytesToWrite];
        Arrays.fill(des_buf, (byte)0);
        if (OffsetSize + nBytesToWrite > WriteBuffer.length) {
            des_buf = null;
            return 0;
        }
        System.arraycopy(WriteBuffer, OffsetSize, des_buf, 0, nBytesToWrite);
        if (des_buf.length > 4096) {
            temp_buf = new byte[4096];
            Arrays.fill(temp_buf, (byte)0);
            mode_len = des_buf.length / 4096;
            res_len = des_buf.length % 4096;
            count = 0;
            while (count < mode_len) {
                tick = System.currentTimeMillis();
                if (tick > totulTick) {
                    temp_buf = null;
                    des_buf = null;
                    return count * 4096;
                }
                System.arraycopy(des_buf, count * 4096 + i, temp_buf, 0, 4096);
                try {
                    this.os.write(temp_buf);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    temp_buf = null;
                    des_buf = null;
                    return count * 4096;
                }
                ++count;
            }
            if (res_len != 0) {
                res_buf = new byte[res_len];
                i = 0;
                while (i < res_len) {
                    res_buf[i] = des_buf[mode_len * 4096 + i];
                    ++i;
                }
                try {
                    this.os.write(res_buf);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    temp_buf = null;
                    res_buf = null;
                    des_buf = null;
                    return 0;
                }
            }
        } else {
            try {
                this.os.write(des_buf);
            }
            catch (IOException e) {
                e.printStackTrace();
                temp_buf = null;
                res_buf = null;
                des_buf = null;
                return 0;
            }
        }
        temp_buf = null;
        res_buf = null;
        des_buf = null;
        return nBytesToWrite;
    }

    @Override
    public int ReadBuffer(byte[] ReadBuffer, int OffsetSize, int nBytesToRead, int ReadTimeOut) {
        try {
            return this.ReadBuffer(ReadBuffer, nBytesToRead, ReadTimeOut);
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int ReadBuffer(byte[] data, int ReadTimeOut) throws IOException, SocketTimeoutException, InterruptedException {
        if (data == null) {
            return 0;
        }
        int data_len = data.length;
        Boolean bBlocking = false;
        ReadThread readThread = new ReadThread();
        readThread.start();
        long beginTime = System.currentTimeMillis();
        while (readThread.isAlive() && System.currentTimeMillis() < beginTime + (long)ReadTimeOut) {
        }
        readThread.close();
        if (readThread != null && readThread.isAlive()) {
            readThread.interrupt();
            bBlocking = true;
        }
        if (this.mBExceptionBoolean.booleanValue()) {
            this.mBExceptionBoolean = false;
            return 0;
        }
        if (!bBlocking.booleanValue() && this.mReadbyte < data_len) {
            System.arraycopy(this.mTempData, 0, data, 0, this.mReadbyte);
            Log.i((String)"Test", (String)new String(data));
        }
        Thread.sleep(100L);
        return this.mReadbyte;
    }

    public int ReadBuffer(byte[] data, int nBytesToRead, int ReadTimeOut) throws IOException, SocketTimeoutException, InterruptedException {
        if (data == null) {
            return 0;
        }
        int data_len = data.length;
        Boolean bBlocking = false;
        ReadThread readThread = new ReadThread();
        readThread.setnBytesToRead(nBytesToRead);
        readThread.start();
        long beginTime = System.currentTimeMillis();
        while (readThread.isAlive() && System.currentTimeMillis() < beginTime + (long)ReadTimeOut) {
        }
        readThread.close();
        if (readThread != null && readThread.isAlive()) {
            readThread.interrupt();
            bBlocking = true;
        }
        if (this.mBExceptionBoolean.booleanValue()) {
            this.mBExceptionBoolean = false;
            return 0;
        }
        if (this.mReadbyte > 0 && this.mReadbyte <= data_len) {
            System.arraycopy(this.mTempData, 0, data, 0, this.mReadbyte);
            Log.i((String)"Test", (String)new String(data));
        }
        return this.mReadbyte;
    }

    @Override
    public int ReadBuffer(byte[] data, String strStart, String strStop) {
        if (data == null) {
            return 0;
        }
        try {
            this.readDataToString(data, strStart, strStop);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return 0;
        }
        if (data.length > 0) {
            Log.i((String)"Test", (String)new String(data));
        }
        return data.length;
    }

    private int readDataToString(byte[] data, String startStr, String stopStr) throws IOException, SocketTimeoutException, InterruptedException {
        int readBytes = 0;
        int read_idx = 0;
        int i = 0;
        int stop_num = 0;
        String des_str = new String();
        byte[] receiveBuf = new byte[10240];
        int data_len = data.length;
        StringBuffer recieveBuffer = new StringBuffer();
        long tick = System.currentTimeMillis();
        long totulTick = tick + 90000L;
        while (true) {
            Arrays.fill(receiveBuf, (byte)0);
            readBytes = this.read(receiveBuf);
            if (readBytes <= 0) continue;
            recieveBuffer.append(new String(receiveBuf).substring(0, readBytes));
            des_str = recieveBuffer.toString();
            read_idx = des_str.indexOf(stopStr);
            if (read_idx > 0) break;
            SystemClock.sleep((long)200L);
            tick = System.currentTimeMillis();
            if (totulTick < tick) break;
        }
        stop_num = stopStr.length();
        read_idx = des_str.indexOf(stopStr);
        Arrays.fill(receiveBuf, (byte)0);
        receiveBuf = des_str.getBytes();
        if (read_idx > 0 && stop_num + read_idx < data_len) {
            read_idx = stop_num + read_idx;
            i = 0;
            while (i < read_idx) {
                data[i] = receiveBuf[i];
                ++i;
            }
            receiveBuf = null;
            return read_idx;
        }
        receiveBuf = null;
        return 0;
    }

    private int read(byte[] data) throws IOException, SocketTimeoutException, InterruptedException {
        if (data == null) {
            return 0;
        }
        int data_len = data.length;
        Boolean bBlocking = false;
        ReadThread readThread = new ReadThread();
        readThread.start();
        long beginTime = System.currentTimeMillis();
        while (readThread.isAlive() && System.currentTimeMillis() < beginTime + (long)this.mTimeout) {
        }
        readThread.close();
        if (readThread != null && readThread.isAlive()) {
            readThread.interrupt();
            bBlocking = true;
        }
        if (this.mBExceptionBoolean.booleanValue()) {
            this.mBExceptionBoolean = false;
            return 0;
        }
        if (!bBlocking.booleanValue() && this.mReadbyte < data_len) {
            System.arraycopy(this.mTempData, 0, data, 0, this.mReadbyte);
            Log.i((String)"Test", (String)new String(data));
        }
        Thread.sleep(this.mTimeAfterRead);
        return this.mReadbyte;
    }

    public String byte2hex(byte[] buffer) {
        String h = "";
        int i = 0;
        while (i < buffer.length) {
            String temp = Integer.toHexString(buffer[i] & 0xFF);
            if (temp.length() == 1) {
                temp = "0" + temp;
            }
            h = String.valueOf(h) + " " + temp;
            ++i;
        }
        return h;
    }

    public void finallize() {
        this.CloseDevice();
        this.closeBluetooth();
    }

    private class ReadInput
    extends Thread {
        private boolean isread = false;
        private int len;
        private byte[] temp = new byte[1024];

        private ReadInput() {
        }

        @Override
        public void run() {
            super.run();
            POSBluetoothAPI.this.ThreadFlg = true;
            this.isread = false;
            try {
                POSBluetoothAPI.this.is = POSBluetoothAPI.this.btSocket.getInputStream();
                if (POSBluetoothAPI.this.is != null) {
                    this.len = POSBluetoothAPI.this.is.read(this.temp);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.isread = false;
            }
            this.isread = true;
            POSBluetoothAPI.this.ThreadFlg = false;
        }

        public boolean isread() {
            return this.isread;
        }

        public int getlen() {
            return this.len;
        }

        public byte[] gettemp() {
            return this.temp;
        }
    }

    private class ReadThread
    extends Thread {
        private volatile boolean isRun = true;
        private int nBytesToRead = 0;

        private ReadThread() {
        }

        @Override
        public void run() {
            super.run();
            POSBluetoothAPI.this.mTempData = new byte[2048];
            POSBluetoothAPI.this.mReadbyte = 0;
            POSBluetoothAPI.this.mBExceptionBoolean = false;
            while (this.nBytesToRead > POSBluetoothAPI.this.mReadbyte) {
                if (!this.isRun) continue;
                try {
                    byte[] thisTempData = new byte[2048];
                    int thisReadbyte = POSBluetoothAPI.this.btSocket.getInputStream().read(thisTempData);
                    if (thisReadbyte > 0) {
                        System.arraycopy(thisTempData, 0, POSBluetoothAPI.this.mTempData, POSBluetoothAPI.this.mReadbyte, thisReadbyte);
                    }
                    POSBluetoothAPI pOSBluetoothAPI = POSBluetoothAPI.this;
                    pOSBluetoothAPI.mReadbyte = pOSBluetoothAPI.mReadbyte + thisReadbyte;
                    Log.i((String)"Blue", (String)new String(POSBluetoothAPI.this.mTempData));
                }
                catch (IOException e) {
                    POSBluetoothAPI.this.mBExceptionBoolean = true;
                    e.printStackTrace();
                }
            }
        }

        public void close() {
            this.isRun = false;
        }

        public void setnBytesToRead(int nBytesToRead) {
            this.nBytesToRead = nBytesToRead;
        }
    }
}

