/*
 * Decompiled with CFR 0.152.
 */
package com.snbc.sdk.connect.connectImpl;

import POSAPI.POSInterfaceAPI;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.SystemClock;
import android.util.Log;
import com.snbc.sdk.connect.IConnect.DeviceConnect;
import com.snbc.sdk.connect.connectImpl.SearchPortInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class WifiConnect
extends POSInterfaceAPI
implements DeviceConnect {
    protected Socket mSocket = null;
    protected int mPort = 9100;
    protected String mIP = null;
    protected OutputStream mOutputStream = null;
    protected InputStream mInputStream = null;
    protected int mTimeOut = 3000;
    protected int mTimeAfterRead = 100;
    protected int mTimeAfterWrite = 100;
    private boolean ThreadFlg = false;
    private byte[] mTempData = null;
    private int mReadbyte = 0;
    private Boolean mBExceptionBoolean = false;
    public static final int READTIMEOUT = 90000;
    public static final int SEARCHTIOMEOUT = 8000;
    public static final int printer_num_max = 20;

    public WifiConnect(String ip, int port) {
        this.mIP = ip;
        this.mPort = port;
    }

    public static boolean isWiFiActive(Context context) {
        NetworkInfo[] infos;
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity != null && (infos = connectivity.getAllNetworkInfo()) != null) {
            NetworkInfo[] networkInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                NetworkInfo ni = networkInfoArray[n2];
                if (ni.getTypeName().equals("WIFI") && ni.isConnected()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static void toggleWiFi(Context context, boolean enabled) {
        WifiManager wm = (WifiManager)context.getSystemService("wifi");
        wm.setWifiEnabled(enabled);
    }

    public static Map<String, String> searchDevice() throws IOException, InterruptedException {
        HashMap<String, String> printerInfoMap = new HashMap<String, String>();
        int prt_num1 = 0;
        int prt_num2 = 0;
        int prt_num = 0;
        int i = 0;
        int k = 0;
        boolean flag = false;
        SearchPortInfo[] temp_port_info1 = new SearchPortInfo[20];
        SearchPortInfo[] temp_port_info2 = new SearchPortInfo[20];
        String temp_ipadd = null;
        i = 0;
        while (i < 20) {
            temp_port_info1[i] = new SearchPortInfo();
            temp_port_info2[i] = new SearchPortInfo();
            ++i;
        }
        prt_num1 = WifiConnect.searchPort(temp_port_info1, 20, 1);
        prt_num2 = WifiConnect.searchPort(temp_port_info2, 20, 2);
        prt_num = prt_num1;
        i = 0;
        while (i < prt_num) {
            printerInfoMap.put(temp_port_info1[i].GetIPAddress(), temp_port_info1[i].GetPrtName());
            ++i;
        }
        if (prt_num >= 20) {
            return printerInfoMap;
        }
        i = 0;
        while (i < prt_num2) {
            flag = false;
            k = 0;
            while (k < prt_num) {
                temp_ipadd = temp_port_info1[k].GetMACAddress();
                flag = temp_ipadd.equals(temp_port_info2[i].GetMACAddress());
                if (flag) break;
                ++k;
            }
            if (!flag) {
                printerInfoMap.put(temp_port_info2[i].GetIPAddress(), temp_port_info2[i].GetPrtName());
                if (++prt_num >= 20) {
                    return printerInfoMap;
                }
            }
            ++i;
        }
        temp_port_info1 = null;
        temp_port_info2 = null;
        return printerInfoMap;
    }

    public static synchronized int searchPort(SearchPortInfo[] port_info, int printer_num_max, int netSegmentSupp) {
        int prt_num = 0;
        int i = 0;
        DatagramSocket sendSocket = null;
        boolean flag = false;
        String mes = null;
        String temp_ipadd = null;
        try {
            sendSocket = new DatagramSocket();
        }
        catch (SocketException e3) {
            e3.printStackTrace();
            return 0;
        }
        if (netSegmentSupp == 1) {
            mes = new String("BG");
        } else if (netSegmentSupp == 2) {
            mes = new String("B[]G");
        } else {
            return 0;
        }
        byte[] buf = mes.getBytes();
        int port = 3000;
        InetAddress ip = null;
        String ip_str = "255.255.255.255";
        byte[] getBuf = new byte[1024];
        long tick = System.currentTimeMillis();
        long totulTick = tick + 8000L;
        do {
            try {
                ip = InetAddress.getByName(ip_str);
            }
            catch (UnknownHostException e2) {
                e2.printStackTrace();
            }
            DatagramPacket sendPacket = new DatagramPacket(buf, buf.length, ip, port);
            try {
                sendSocket.send(sendPacket);
            }
            catch (IOException e) {
                e.printStackTrace();
                prt_num = 0;
                break;
            }
            DatagramPacket getPacket = new DatagramPacket(getBuf, getBuf.length);
            try {
                sendSocket.setSoTimeout(3000);
            }
            catch (SocketException e1) {
                e1.printStackTrace();
                prt_num = 0;
                break;
            }
            block11: do {
                try {
                    sendSocket.receive(getPacket);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
                if (getPacket.getLength() == 0) break;
                String backMes = new String(getBuf, 0, getPacket.getLength());
                char[] temp_mes = backMes.toCharArray();
                int Ipos_bg = 0;
                if (backMes.length() < 1) break;
                port_info[prt_num].SetAllinfo(backMes);
                i = Ipos_bg = backMes.indexOf("IP:");
                while (i < temp_mes.length) {
                    if (temp_mes[i] == ';') {
                        port_info[prt_num].SetIPAddress(backMes.substring(Ipos_bg + 3, i));
                        break;
                    }
                    ++i;
                }
                i = Ipos_bg = backMes.indexOf("DEVICENAME:");
                while (i < temp_mes.length) {
                    if (temp_mes[i] == ';') {
                        port_info[prt_num].SetPrtName(backMes.substring(Ipos_bg + 11, i));
                        break;
                    }
                    ++i;
                }
                i = Ipos_bg = backMes.indexOf("MAC:");
                while (i < temp_mes.length) {
                    if (temp_mes[i] == ';') {
                        port_info[prt_num].SetMACAddress(backMes.substring(Ipos_bg + 4, i));
                        break;
                    }
                    ++i;
                }
                if (++prt_num >= printer_num_max) break;
                i = 0;
                while (i < prt_num - 1) {
                    temp_ipadd = port_info[i].GetMACAddress();
                    flag = temp_ipadd.equals(port_info[prt_num - 1].GetMACAddress());
                    if (flag) continue block11;
                    ++i;
                }
            } while (!flag);
            SystemClock.sleep((long)100L);
        } while (totulTick >= (tick = System.currentTimeMillis()));
        sendSocket.close();
        buf = null;
        getBuf = null;
        return prt_num;
    }

    @Override
    public void connect() throws IOException {
        try {
            this.mSocket = new Socket(this.mIP, this.mPort);
            this.mSocket.setSoTimeout(this.mTimeOut);
            this.mOutputStream = this.mSocket.getOutputStream();
            this.mInputStream = this.mSocket.getInputStream();
        }
        catch (Exception e) {
            Log.i((String)"Error", (String)new String("wifi connect Io Error!"));
            throw new IOException();
        }
    }

    @Override
    public void write(byte[] data) throws IOException, SocketTimeoutException, SocketTimeoutException, InterruptedException {
        if (data == null) {
            return;
        }
        try {
            this.mOutputStream.write(data);
            this.mOutputStream.flush();
            int delay = data.length / 5;
            if (delay == 0) {
                delay = 1;
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Log.i((String)"write", (String)new String(data));
        }
        catch (SocketTimeoutException e) {
            throw new SocketTimeoutException();
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    @Override
    public void write(String data) throws IOException, SocketTimeoutException, InterruptedException {
        if (data == null) {
            return;
        }
        try {
            this.mOutputStream.write(data.getBytes("UTF-8"));
            this.mOutputStream.flush();
            int delay = data.length() / 5;
            if (delay == 0) {
                delay = 1;
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Log.i((String)"write", (String)data);
        }
        catch (SocketTimeoutException e) {
            throw new SocketTimeoutException();
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    @Override
    public int read(byte[] data) throws IOException, SocketTimeoutException, InterruptedException {
        if (data == null) {
            return 0;
        }
        byte[] mTempData = new byte[2048];
        int data_len = data.length;
        try {
            int readBytes = this.mInputStream.read(mTempData);
            Thread.sleep(this.mTimeAfterRead);
            Log.i((String)"read", (String)new String(mTempData));
            Log.i((String)"read", (String)String.format("ReadBytes = %d", readBytes));
            if (readBytes < data_len) {
                System.arraycopy(mTempData, 0, data, 0, readBytes);
                return readBytes;
            }
            Log.i((String)"read", (String)new String("read fail"));
            return 0;
        }
        catch (SocketTimeoutException e) {
            throw new SocketTimeoutException();
        }
        catch (InterruptedException e) {
            throw new IOException();
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    @Override
    public int readDataToString(byte[] data, String startStr, String stopStr) throws IOException, SocketTimeoutException, InterruptedException {
        int readBytes = 0;
        int read_idx = 0;
        int i = 0;
        int stop_num = 0;
        String des_str = new String();
        byte[] receiveBuf = new byte[10240];
        int data_len = data.length;
        StringBuffer recieveBuffer = new StringBuffer();
        long tick = System.currentTimeMillis();
        long totulTick = tick + 90000L;
        while (true) {
            Arrays.fill(receiveBuf, (byte)0);
            readBytes = this.read(receiveBuf);
            if (readBytes <= 0) continue;
            recieveBuffer.append(new String(receiveBuf).substring(0, readBytes));
            des_str = recieveBuffer.toString();
            read_idx = des_str.indexOf(stopStr);
            if (read_idx > 0) break;
            SystemClock.sleep((long)200L);
            tick = System.currentTimeMillis();
            if (totulTick < tick) break;
        }
        stop_num = stopStr.length();
        read_idx = des_str.indexOf(stopStr);
        Arrays.fill(receiveBuf, (byte)0);
        receiveBuf = des_str.getBytes();
        if (read_idx > 0 && stop_num + read_idx < data_len) {
            read_idx = stop_num + read_idx;
            i = 0;
            while (i < read_idx) {
                data[i] = receiveBuf[i];
                ++i;
            }
            receiveBuf = null;
            return read_idx;
        }
        receiveBuf = null;
        return 0;
    }

    @Override
    public void disconnect() throws IOException {
        try {
            this.mOutputStream.close();
            this.mInputStream.close();
            this.mSocket.close();
        }
        catch (Exception e) {
            Log.i((String)"Error", (String)new String("wifi disconnect Io Error!"));
            throw new IOException();
        }
    }

    @Override
    public void setTimeout(int timeout) throws IllegalArgumentException {
        if (timeout < 0) {
            throw new IllegalArgumentException();
        }
        this.mTimeOut = timeout;
    }

    @Override
    public void setWaitTimeAfterRead(int timeout) throws IllegalArgumentException {
        if (timeout < 0) {
            throw new IllegalArgumentException();
        }
        this.mTimeAfterRead = timeout;
    }

    @Override
    public void setWaitTimeAfterWrite(int timeout) throws IllegalArgumentException {
        if (timeout < 0) {
            throw new IllegalArgumentException();
        }
        this.mTimeAfterWrite = timeout;
    }

    @Override
    public int WriteBuffer(byte[] WriteBuffer, int OffsetSize, int nBytesToWrite, int WriteTimeOut) {
        try {
            this.write(WriteBuffer);
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
            return 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return 0;
        }
        return WriteBuffer.length;
    }

    @Override
    public int ReadBuffer(byte[] ReadBuffer, int OffsetSize, int nBytesToRead, int ReadTimeOut) {
        try {
            this.ReadBuffer(ReadBuffer, nBytesToRead, ReadTimeOut);
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
            return 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return 0;
        }
        return ReadBuffer.length;
    }

    @Override
    public int ReadBuffer(byte[] ReadBuffer, String strStart, String strStop) {
        try {
            this.readDataToString(ReadBuffer, strStart, strStop);
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
            return 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return 0;
        }
        return ReadBuffer.length;
    }

    public int ReadBuffer(byte[] data, int nBytesToRead, int ReadTimeOut) throws IOException, SocketTimeoutException, InterruptedException {
        if (data == null) {
            return 0;
        }
        int data_len = data.length;
        Boolean bBlocking = false;
        ReadThread readThread = new ReadThread();
        readThread.setnBytesToRead(nBytesToRead);
        readThread.start();
        long beginTime = System.currentTimeMillis();
        while (readThread.isAlive() && System.currentTimeMillis() < beginTime + (long)ReadTimeOut) {
        }
        readThread.close();
        if (readThread != null && readThread.isAlive()) {
            readThread.interrupt();
            bBlocking = true;
        }
        if (this.mBExceptionBoolean.booleanValue()) {
            this.mBExceptionBoolean = false;
            return 0;
        }
        if (this.mReadbyte > 0 && this.mReadbyte <= data_len) {
            System.arraycopy(this.mTempData, 0, data, 0, this.mReadbyte);
            Log.i((String)"Test", (String)new String(data));
        }
        return this.mReadbyte;
    }

    @Override
    public int OpenDevice(String dstName, int dstPort) {
        try {
            new WifiConnect(dstName, dstPort);
            this.connect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 1000;
    }

    @Override
    public int CloseDevice() {
        try {
            this.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 1000;
    }

    private class ReadInput
    extends Thread {
        private boolean isread = false;
        private int len;
        private byte[] temp = new byte[1024];

        private ReadInput() {
        }

        @Override
        public void run() {
            super.run();
            WifiConnect.this.ThreadFlg = true;
            try {
                this.len = WifiConnect.this.mInputStream.read(this.temp);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.isread = true;
            WifiConnect.this.ThreadFlg = false;
        }

        public boolean isread() {
            return this.isread;
        }

        public int getlen() {
            return this.len;
        }

        public byte[] gettemp() {
            return this.temp;
        }
    }

    private class ReadThread
    extends Thread {
        private volatile boolean isRun = true;
        private int nBytesToRead = 0;

        private ReadThread() {
        }

        @Override
        public void run() {
            super.run();
            WifiConnect.this.mTempData = new byte[2048];
            WifiConnect.this.mReadbyte = 0;
            WifiConnect.this.mBExceptionBoolean = false;
            while (this.nBytesToRead > WifiConnect.this.mReadbyte) {
                if (!this.isRun) continue;
                try {
                    byte[] thisTempData = new byte[2048];
                    int thisReadbyte = WifiConnect.this.mInputStream.read(thisTempData);
                    if (thisReadbyte > 0) {
                        System.arraycopy(thisTempData, 0, WifiConnect.this.mTempData, WifiConnect.this.mReadbyte, thisReadbyte);
                    }
                    WifiConnect wifiConnect = WifiConnect.this;
                    wifiConnect.mReadbyte = wifiConnect.mReadbyte + thisReadbyte;
                    Log.i((String)"Wi-Fi", (String)new String(WifiConnect.this.mTempData));
                }
                catch (IOException e) {
                    WifiConnect.this.mBExceptionBoolean = true;
                    e.printStackTrace();
                }
            }
        }

        public void close() {
            this.isRun = false;
        }

        public void setnBytesToRead(int nBytesToRead) {
            this.nBytesToRead = nBytesToRead;
        }
    }
}

