/*
 * Decompiled with CFR 0.152.
 */
package android_wifi_api;

import android.content.Context;
import android.net.DhcpInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.text.format.Formatter;
import android.util.Log;
import java.util.List;

public class WiFiSDKAPI {
    private static final String LOG_TAG = "SNBC WifiAdmin";
    public static final int WIFI_STATE_DISABLING = 0;
    public static final int WIFI_STATE_DISABLED = 1;
    public static final int WIFI_STATE_ENABLING = 2;
    public static final int WIFI_STATE_ENABLED = 3;
    public static final int WIFI_STATE_UNKNOWN = 4;
    private WifiManager mWifiManager;
    private WifiInfo mWifiInfo;
    private List<ScanResult> mScanResults;
    private List<WifiConfiguration> mWifiConfigurations;
    private static WiFiSDKAPI mWifiAdmin = null;
    private DhcpInfo mDhcpInfo;

    private WiFiSDKAPI(Context context) {
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        this.mDhcpInfo = this.mWifiManager.getDhcpInfo();
    }

    public static synchronized WiFiSDKAPI getInstance(Context context) {
        if (mWifiAdmin == null) {
            mWifiAdmin = new WiFiSDKAPI(context);
        }
        return mWifiAdmin;
    }

    public boolean setWifiEnabled(boolean enabled) {
        return this.mWifiManager.setWifiEnabled(enabled);
    }

    public boolean isWifiEnabled() {
        return this.getWifiState() == 3;
    }

    public int getWifiState() {
        return this.mWifiManager.getWifiState();
    }

    private boolean startScan() {
        boolean result = false;
        result = this.mWifiManager.startScan();
        if (!result) {
            Log.e((String)LOG_TAG, (String)"Fail to scan");
        } else {
            Log.e((String)LOG_TAG, (String)"Success to scan");
            this.mScanResults = this.mWifiManager.getScanResults();
            this.mWifiConfigurations = this.mWifiManager.getConfiguredNetworks();
        }
        return result;
    }

    public List<ScanResult> getScanResults() {
        if (this.startScan()) {
            return this.mScanResults;
        }
        return null;
    }

    public List<WifiConfiguration> getConfiguredNetworks() {
        this.startScan();
        return this.mWifiConfigurations;
    }

    public boolean connectConfiguredNetwork(int id) {
        if (this.mWifiConfigurations == null || this.mWifiConfigurations.size() <= 0) {
            return false;
        }
        if (id >= this.mWifiConfigurations.size()) {
            Log.e((String)LOG_TAG, (String)"\u53c2\u6570 id\u8d85\u51fa\u4e86\u7f51\u7edc\u8fde\u63a5\u5217\u8868\u7684\u957f\u5ea6");
            return false;
        }
        try {
            return this.mWifiManager.enableNetwork(this.mWifiConfigurations.get((int)id).networkId, true);
        }
        catch (Exception e) {
            return false;
        }
    }

    public WifiInfo getConnectionInfo() {
        return this.mWifiInfo;
    }

    public int getNetworkId() {
        return this.mWifiInfo == null ? -1 : this.mWifiInfo.getNetworkId();
    }

    public boolean disconnectWifi(int netId) {
        return this.mWifiManager.disableNetwork(netId) && this.mWifiManager.disconnect();
    }

    public boolean addNetwork(WifiConfiguration wifiConfig) {
        try {
            int wifiConfigID = this.mWifiManager.addNetwork(wifiConfig);
            Log.e((String)"addNetwork wifiConfigID ", (String)String.valueOf(wifiConfigID));
            boolean result = this.mWifiManager.enableNetwork(wifiConfigID, true);
            Log.e((String)"addNetwork result", (String)String.valueOf(result));
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getMacAddress() {
        return this.mWifiInfo == null ? "NULL" : this.mWifiInfo.getMacAddress();
    }

    public String getIPAddress() {
        return this.mWifiInfo == null ? "NULL" : Formatter.formatIpAddress((int)this.mWifiInfo.getIpAddress());
    }

    public String getBSSID() {
        return this.mWifiInfo == null ? "NULL" : this.mWifiInfo.getBSSID();
    }

    public String getDhcpIPAddress() {
        return this.mDhcpInfo == null ? "NULL" : Formatter.formatIpAddress((int)this.mDhcpInfo.ipAddress);
    }
}

