/*
 * Decompiled with CFR 0.152.
 */
package POSAPI;

import POSAPI.POSInterfaceAPI;
import android.os.SystemClock;
import android_wifi_api.SearchPortInfo;
import android_wifi_api.SocketSDK;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;

public class POSWIFIAPI
extends POSInterfaceAPI {
    private static final String LOG_TAG = "SNBC_WIFI_POS_SDK_API";
    private static final String D = "D";
    private static final String E = "E";
    public SocketSDK mSocketSDK;
    public static final int POS_SUCCESS = 1000;
    public static final int ERR_PROCESSING = 1001;
    public static final int POS_FAIL = 1002;
    public static final int WRITETIMEOUT = 10000;
    public static final int WRITEBYTEMAX = 4096;
    public static final int READBYTEMAX = 1024;
    private boolean ThreadFlg = false;
    String dstName;
    int dstPort;

    @Override
    public synchronized int WIFISearchPort(SearchPortInfo[] port_info, int printer_num_max) {
        int prt_num1 = 0;
        int prt_num2 = 0;
        int prt_num = 0;
        int i = 0;
        int k = 0;
        boolean flag = false;
        SearchPortInfo[] temp_port_info = new SearchPortInfo[printer_num_max];
        String temp_ipadd = null;
        i = 0;
        while (i < printer_num_max) {
            temp_port_info[i] = new SearchPortInfo();
            ++i;
        }
        prt_num1 = this.searchPort(port_info, printer_num_max, 1);
        prt_num2 = this.searchPort(temp_port_info, printer_num_max, 2);
        prt_num = prt_num1;
        if (prt_num >= printer_num_max) {
            return prt_num;
        }
        i = 0;
        while (i < prt_num2) {
            flag = false;
            k = 0;
            while (k < prt_num) {
                temp_ipadd = port_info[k].GetMACAddress();
                flag = temp_ipadd.equals(temp_port_info[i].GetMACAddress());
                if (flag) break;
                ++k;
            }
            if (!flag) {
                port_info[prt_num++] = temp_port_info[i];
                if (prt_num >= printer_num_max) {
                    return prt_num;
                }
            }
            ++i;
        }
        temp_port_info = null;
        return prt_num;
    }

    public synchronized int searchPort(SearchPortInfo[] port_info, int printer_num_max, int netSegmentSupp) {
        int prt_num = 0;
        int i = 0;
        DatagramSocket sendSocket = null;
        boolean flag = false;
        String mes = null;
        String temp_ipadd = null;
        try {
            sendSocket = new DatagramSocket();
        }
        catch (SocketException e3) {
            e3.printStackTrace();
            return 0;
        }
        if (netSegmentSupp == 1) {
            mes = new String("BG");
        } else if (netSegmentSupp == 2) {
            mes = new String("B[]G");
        } else {
            return 0;
        }
        byte[] buf = mes.getBytes();
        int port = 3000;
        InetAddress ip = null;
        String ip_str = "255.255.255.255";
        try {
            ip = InetAddress.getByName(ip_str);
        }
        catch (UnknownHostException e2) {
            e2.printStackTrace();
        }
        DatagramPacket sendPacket = new DatagramPacket(buf, buf.length, ip, port);
        try {
            sendSocket.send(sendPacket);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        byte[] getBuf = new byte[1024];
        DatagramPacket getPacket = new DatagramPacket(getBuf, getBuf.length);
        try {
            sendSocket.setSoTimeout(3000);
        }
        catch (SocketException e1) {
            e1.printStackTrace();
            return 0;
        }
        block10: do {
            try {
                sendSocket.receive(getPacket);
            }
            catch (IOException e) {
                e.printStackTrace();
                break;
            }
            if (getPacket.getLength() == 0) break;
            String backMes = new String(getBuf, 0, getPacket.getLength());
            char[] temp_mes = backMes.toCharArray();
            int Ipos_bg = 0;
            if (backMes.length() < 1) break;
            port_info[prt_num].SetAllinfo(backMes);
            i = Ipos_bg = backMes.indexOf("IP:");
            while (i < temp_mes.length) {
                if (temp_mes[i] == ';') {
                    port_info[prt_num].SetIPAddress(backMes.substring(Ipos_bg + 3, i));
                    break;
                }
                ++i;
            }
            i = Ipos_bg = backMes.indexOf("DEVICENAME:");
            while (i < temp_mes.length) {
                if (temp_mes[i] == ';') {
                    port_info[prt_num].SetPrtName(backMes.substring(Ipos_bg + 11, i));
                    break;
                }
                ++i;
            }
            i = Ipos_bg = backMes.indexOf("MAC:");
            while (i < temp_mes.length) {
                if (temp_mes[i] == ';') {
                    port_info[prt_num].SetMACAddress(backMes.substring(Ipos_bg + 4, i));
                    break;
                }
                ++i;
            }
            if (++prt_num >= printer_num_max) break;
            i = 0;
            while (i < prt_num - 1) {
                temp_ipadd = port_info[i].GetMACAddress();
                flag = temp_ipadd.equals(port_info[prt_num - 1].GetMACAddress());
                if (flag) continue block10;
                ++i;
            }
        } while (!flag);
        sendSocket.close();
        buf = null;
        getBuf = null;
        return prt_num;
    }

    @Override
    public int OpenDevice(String dstName, int dstPort) {
        int result = 1000;
        this.dstName = dstName;
        this.dstPort = dstPort;
        this.mSocketSDK = new SocketSDK(dstName, dstPort);
        if (!this.mSocketSDK.isConnected()) {
            result = 1001;
        }
        return result;
    }

    @Override
    public int CloseDevice() {
        int result = 1000;
        if (this.mSocketSDK.socket != null && !this.mSocketSDK.clearSocket()) {
            result = 1001;
        }
        return result;
    }

    @Override
    public int WriteBuffer(byte[] WriteBuffer, int OffsetSize, int nBytesToWrite, int WriteTimeOut) {
        int i = 0;
        int res_len = 0;
        int mode_len = 0;
        int count = 0;
        long tick = 0L;
        long totulTick = 0L;
        byte[] temp_buf = null;
        byte[] res_buf = null;
        if (WriteBuffer == null || nBytesToWrite <= 0 || OffsetSize < 0) {
            return 0;
        }
        if (!this.mSocketSDK.getConnectedToPos()) {
            this.CloseDevice();
            if (this.OpenDevice(this.dstName, this.dstPort) != 1000) {
                return 0;
            }
        }
        tick = System.currentTimeMillis();
        totulTick = tick + (long)WriteTimeOut;
        byte[] des_buf = new byte[nBytesToWrite];
        Arrays.fill(des_buf, (byte)0);
        if (OffsetSize + nBytesToWrite > WriteBuffer.length) {
            des_buf = null;
            return 0;
        }
        System.arraycopy(WriteBuffer, OffsetSize, des_buf, 0, nBytesToWrite);
        if (des_buf.length > 4096) {
            boolean issucceed;
            temp_buf = new byte[4096];
            Arrays.fill(temp_buf, (byte)0);
            mode_len = des_buf.length / 4096;
            res_len = des_buf.length % 4096;
            count = 0;
            while (count < mode_len) {
                tick = System.currentTimeMillis();
                if (tick > totulTick) {
                    temp_buf = null;
                    des_buf = null;
                    return count * 4096;
                }
                System.arraycopy(des_buf, count * 4096 + i, temp_buf, 0, 4096);
                issucceed = this.mSocketSDK.write(temp_buf);
                if (!issucceed) {
                    temp_buf = null;
                    des_buf = null;
                    return count * 4096;
                }
                ++count;
            }
            if (res_len != 0) {
                res_buf = new byte[res_len];
                i = 0;
                while (i < res_len) {
                    res_buf[i] = des_buf[mode_len * 4096 + i];
                    ++i;
                }
                issucceed = this.mSocketSDK.write(res_buf);
                if (!issucceed) {
                    temp_buf = null;
                    res_buf = null;
                    des_buf = null;
                    return 0;
                }
            }
        } else {
            boolean issucceed = this.mSocketSDK.write(des_buf);
            if (!issucceed) {
                des_buf = null;
                return 0;
            }
        }
        temp_buf = null;
        res_buf = null;
        des_buf = null;
        return nBytesToWrite;
    }

    @Override
    public int ReadBuffer(byte[] ReadBuffer, int OffsetSize, int nBytesToRead, int ReadTimeOut) {
        int read_size = 1000;
        int i = 0;
        ReadInput read_thread = new ReadInput();
        if (this.mSocketSDK == null || nBytesToRead < 1) {
            return 0;
        }
        byte[] temp_buf = new byte[1024];
        if (!this.ThreadFlg) {
            read_thread.start();
            long tick = System.currentTimeMillis();
            long totulTick = tick + (long)ReadTimeOut;
            while (!read_thread.isread()) {
                SystemClock.sleep((long)500L);
                tick = System.currentTimeMillis();
                if (totulTick < tick) break;
            }
            if (read_thread.isread()) {
                read_size = read_thread.getlen();
                temp_buf = read_thread.gettemp();
            } else {
                read_thread.stop();
                this.ThreadFlg = false;
                temp_buf = null;
                return 0;
            }
        }
        if (read_size > 0) {
            i = OffsetSize;
            while (i < OffsetSize + read_size) {
                ReadBuffer[i] = temp_buf[i - OffsetSize];
                ++i;
            }
            temp_buf = null;
            return read_size;
        }
        temp_buf = null;
        return 0;
    }

    private class ReadInput
    extends Thread {
        private boolean isread = false;
        private int len;
        private byte[] temp = new byte[1024];

        private ReadInput() {
        }

        @Override
        public void run() {
            super.run();
            POSWIFIAPI.this.ThreadFlg = true;
            this.len = POSWIFIAPI.this.mSocketSDK.read(this.temp);
            this.isread = true;
            POSWIFIAPI.this.ThreadFlg = false;
        }

        public boolean isread() {
            return this.isread;
        }

        public int getlen() {
            return this.len;
        }

        public byte[] gettemp() {
            return this.temp;
        }
    }
}

