/*
 * Decompiled with CFR 0.152.
 */
package POSAPI;

import POSAPI.POSInterfaceAPI;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.hardware.usb.IUsbManager;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class POSUSBAPI
extends POSInterfaceAPI {
    private Context mActivity;
    private static final String LOG_TAG = "SNBC_POS";
    public static final int POS_SUCCESS = 1000;
    public static final int ERR_PROCESSING = 1001;
    public static final int WRITEBYTEMAX = 4096;
    private static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";
    public UsbManager mUsbManager;
    private PendingIntent mPermissionIntent;
    public UsbAccessory mAccessory;
    ParcelFileDescriptor mFileDescriptor;
    FileOutputStream mOutputStream;
    FileInputStream mInputStream;
    private UsbDevice device = null;
    private UsbDevice des_dev = null;
    private UsbDeviceConnection connection = null;
    private boolean request_flag = true;
    private Intent intent;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            UsbAccessory accessory;
            String action = intent.getAction();
            if (POSUSBAPI.ACTION_USB_PERMISSION.equals(action)) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    POSUSBAPI.this.device = (UsbDevice)intent.getParcelableExtra("accessory");
                    intent.getBooleanExtra("permission", false);
                }
            } else if ("android.hardware.usb.action.USB_ACCESSORY_DETACHED".equals(action) && (accessory = (UsbAccessory)intent.getParcelableExtra("accessory")) != null) {
                accessory.equals((Object)POSUSBAPI.this.mAccessory);
            }
        }
    };
    public final BroadcastReceiver mUsbPermissionReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (!POSUSBAPI.ACTION_USB_PERMISSION.equals(action)) {
                if (!"android.hardware.usb.action.USB_ACCESSORY_DETACHED".equals(action)) return;
                2 v0 = this;
                // MONITORENTER : v0
                // MONITOREXIT : v0
                return;
            }
            2 var4_4 = this;
            // MONITORENTER : var4_4
            POSUSBAPI.this.device = (UsbDevice)intent.getParcelableExtra("device");
            Log.i((String)POSUSBAPI.LOG_TAG, (String)("UsbManager.EXTRA_DEVICE" + intent.getParcelableExtra("device")));
            Log.i((String)POSUSBAPI.LOG_TAG, (String)("Is it have permissons  " + POSUSBAPI.this.mUsbManager.hasPermission(POSUSBAPI.this.device)));
            if (intent.getBooleanExtra("permission", false)) {
                if (POSUSBAPI.this.device == null) return;
                Log.i((String)POSUSBAPI.LOG_TAG, (String)("Opening reader: " + POSUSBAPI.this.device.getDeviceName() + "..."));
                return;
            } else {
                Log.i((String)POSUSBAPI.LOG_TAG, (String)("Permission no EXTRA_PERMISSION_GRANTED for device " + POSUSBAPI.this.device.getDeviceName()));
            }
            // MONITOREXIT : var4_4
            return;
        }
    };

    public POSUSBAPI(Context activity) {
        this.mActivity = activity;
        try {
            this.mUsbManager = (UsbManager)activity.getSystemService("usb");
            HashMap deviceList = this.mUsbManager.getDeviceList();
            for (UsbDevice this.device : deviceList.values()) {
                if (this.device.getVendorId() == 5455 || this.device.getVendorId() == 1008) break;
            }
            this.mPermissionIntent = PendingIntent.getBroadcast((Context)activity, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
            this.intent = new Intent();
            this.intent.setAction(ACTION_USB_PERMISSION);
            IntentFilter filter = new IntentFilter();
            filter.addAction(ACTION_USB_PERMISSION);
            filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
            activity.registerReceiver(this.mUsbPermissionReceiver, filter);
            this.intent.putExtra("device", (Parcelable)this.device);
            this.intent.putExtra("permission", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int USBManagerOpen() {
        this.mUsbManager = (UsbManager)this.mActivity.getSystemService("usb");
        HashMap deviceList = this.mUsbManager.getDeviceList();
        Iterator deviceIterator = deviceList.values().iterator();
        for (UsbDevice device : deviceList.values()) {
            device = (UsbDevice)deviceIterator.next();
            Log.i((String)LOG_TAG, (String)(String.valueOf(String.format("pid = %d vid = %d deviceid = %d class=%d subClass = %d ", device.getProductId(), device.getVendorId(), device.getDeviceId(), device.getDeviceClass(), device.getDeviceSubclass())) + device.getDeviceName()));
            if (device.getVendorId() != 5455 || device.getProductId() != 5455) continue;
            this.des_dev = device;
            Context activity = this.mActivity;
            this.intent.putExtra("device", (Parcelable)device);
            this.intent.putExtra("permission", true);
            PackageManager pm = activity.getPackageManager();
            try {
                ApplicationInfo aInfo = pm.getApplicationInfo(activity.getPackageName(), 0);
                IBinder b = ServiceManager.getService("usb");
                IUsbManager service = IUsbManager.Stub.asInterface(b);
                service.grantDevicePermission(device, aInfo.uid);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            activity.sendBroadcast(this.intent);
            if (this.des_dev != null) {
                this.connection = this.mUsbManager.openDevice(this.des_dev);
                if (this.connection != null) {
                    return 1000;
                }
                this.des_dev = null;
                return 1001;
            }
            return 1001;
        }
        return 1001;
    }

    @Override
    public int USBManagerOpen(int Vid, int Pid) {
        this.mUsbManager = (UsbManager)this.mActivity.getSystemService("usb");
        HashMap deviceList = this.mUsbManager.getDeviceList();
        Iterator deviceIterator = deviceList.values().iterator();
        for (UsbDevice device : deviceList.values()) {
            device = (UsbDevice)deviceIterator.next();
            Log.i((String)LOG_TAG, (String)(String.valueOf(String.format("pid = %d vid = %d deviceid = %d class=%d subClass = %d ", device.getProductId(), device.getVendorId(), device.getDeviceId(), device.getDeviceClass(), device.getDeviceSubclass())) + device.getDeviceName()));
            if (device.getVendorId() != Vid || device.getProductId() != Pid) continue;
            this.des_dev = device;
            Context activity = this.mActivity;
            this.intent.putExtra("device", (Parcelable)device);
            this.intent.putExtra("permission", true);
            PackageManager pm = activity.getPackageManager();
            try {
                ApplicationInfo aInfo = pm.getApplicationInfo(activity.getPackageName(), 0);
                IBinder b = ServiceManager.getService("usb");
                IUsbManager service = IUsbManager.Stub.asInterface(b);
                service.grantDevicePermission(device, aInfo.uid);
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            activity.sendBroadcast(this.intent);
            if (this.des_dev != null) {
                this.connection = this.mUsbManager.openDevice(this.des_dev);
                if (this.connection != null) {
                    return 1000;
                }
                this.des_dev = null;
                return 1001;
            }
            return 1001;
        }
        return 1001;
    }

    /*
     * Unable to fully structure code
     */
    private int requestUSBPermission(int Vid, int Pid) {
        this.mUsbManager = (UsbManager)this.mActivity.getSystemService("usb");
        deviceList = this.mUsbManager.getDeviceList();
        deviceIterator = deviceList.values().iterator();
        if (deviceIterator.hasNext()) ** GOTO lbl10
        this.device = null;
        return 1001;
lbl-1000:
        // 1 sources

        {
            this.device = (UsbDevice)deviceIterator.next();
            if (this.device.getVendorId() == Vid || this.device.getVendorId() == Pid) break;
            this.device = null;
lbl10:
            // 2 sources

            ** while (deviceIterator.hasNext())
        }
lbl11:
        // 2 sources

        if (this.device == null) {
            return 1001;
        }
        if (this.des_dev != null && this.device != null && this.des_dev.equals((Object)this.device) && !this.request_flag) {
            return 1000;
        }
        activity = this.mActivity;
        this.mPermissionIntent = PendingIntent.getBroadcast((Context)activity, (int)0, (Intent)new Intent("com.android.example.USB_PERMISSION"), (int)0);
        filter = new IntentFilter("com.android.example.USB_PERMISSION");
        activity.registerReceiver(this.mUsbReceiver, filter);
        if (!this.request_flag && this.device != null && this.des_dev != null && !this.des_dev.equals((Object)this.device) || this.request_flag && this.device != null) {
            this.des_dev = this.device;
            if (this.device.getVendorId() == Vid || this.device.getVendorId() == Pid) {
                this.mUsbManager.requestPermission(this.device, this.mPermissionIntent);
                this.request_flag = false;
            }
        }
        return 1000;
    }

    @Override
    public int OpenDevice() {
        block5: {
            block6: {
                int ret = this.requestUSBPermission(5455, 1008);
                if (ret != 1000) {
                    return ret;
                }
                try {
                    if (this.des_dev == null || this.mUsbManager == null) break block5;
                    this.connection = this.mUsbManager.openDevice(this.des_dev);
                    if (this.connection == null) break block6;
                    return 1000;
                }
                catch (Exception e) {
                    return 1001;
                }
            }
            this.request_flag = true;
            this.des_dev = null;
            return 1001;
        }
        this.request_flag = true;
        return 1001;
    }

    @Override
    public int OpenDevice(int Vid, int Pid) {
        boolean flag = false;
        this.mUsbManager = (UsbManager)this.mActivity.getSystemService("usb");
        HashMap deviceList = this.mUsbManager.getDeviceList();
        for (UsbDevice this.device : deviceList.values()) {
            if (this.device.getVendorId() != Vid || this.device.getProductId() != Pid) continue;
            flag = true;
            break;
        }
        if (this.device == null || !flag) {
            return 1001;
        }
        Context activity = this.mActivity;
        this.mPermissionIntent = PendingIntent.getBroadcast((Context)activity, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
        activity.registerReceiver(this.mUsbReceiver, filter);
        if (flag && this.device != null) {
            this.des_dev = this.device;
            this.mUsbManager.requestPermission(this.device, this.mPermissionIntent);
            flag = false;
        }
        if (this.des_dev != null) {
            this.connection = this.mUsbManager.openDevice(this.des_dev);
            if (this.connection != null) {
                return 1000;
            }
            this.des_dev = null;
            return 1001;
        }
        return 1001;
    }

    @Override
    public int WriteBuffer(byte[] WriteBuffer, int OffsetSize, int nBytesToWrite, int WriteTimeOut) {
        UsbEndpoint endpoint;
        int write_size = 0;
        int i = 0;
        boolean k = false;
        int res_len = 0;
        int mode_len = 0;
        int count = 0;
        long tick = 0L;
        long totulTick = 0L;
        byte[] temp_buf = null;
        if (this.des_dev == null || this.connection == null || WriteBuffer == null || nBytesToWrite <= 0 || OffsetSize < 0) {
            return 0;
        }
        try {
            UsbInterface intf = this.des_dev.getInterface(0);
            endpoint = intf.getEndpoint(0);
            boolean forceClaim = true;
            this.connection.claimInterface(intf, forceClaim);
        }
        catch (Exception e) {
            return 0;
        }
        tick = System.currentTimeMillis();
        totulTick = tick + (long)WriteTimeOut;
        byte[] des_buf = new byte[nBytesToWrite];
        Arrays.fill(des_buf, (byte)0);
        if (OffsetSize + nBytesToWrite > WriteBuffer.length) {
            des_buf = null;
            return 0;
        }
        System.arraycopy(WriteBuffer, OffsetSize, des_buf, 0, nBytesToWrite);
        if (des_buf.length > 4096) {
            temp_buf = new byte[4096];
            Arrays.fill(temp_buf, (byte)0);
            mode_len = des_buf.length / 4096;
            res_len = des_buf.length % 4096;
            count = 0;
            while (count < mode_len) {
                tick = System.currentTimeMillis();
                if (tick > totulTick) {
                    temp_buf = null;
                    des_buf = null;
                    return count * 4096;
                }
                System.arraycopy(des_buf, count * 4096 + i, temp_buf, 0, 4096);
                write_size = this.connection.bulkTransfer(endpoint, temp_buf, 4096, WriteTimeOut);
                if (write_size != 4096) {
                    temp_buf = null;
                    des_buf = null;
                    return count * 4096;
                }
                ++count;
            }
            if (res_len != 0) {
                i = 0;
                while (i < res_len) {
                    temp_buf[i] = des_buf[mode_len * 4096 + i];
                    ++i;
                }
                write_size = this.connection.bulkTransfer(endpoint, temp_buf, res_len, WriteTimeOut);
                if (write_size == res_len) {
                    temp_buf = null;
                    des_buf = null;
                    return nBytesToWrite;
                }
                temp_buf = null;
                des_buf = null;
                return 0;
            }
            temp_buf = null;
            des_buf = null;
            return nBytesToWrite;
        }
        write_size = this.connection.bulkTransfer(endpoint, des_buf, nBytesToWrite, WriteTimeOut);
        if (write_size == nBytesToWrite) {
            temp_buf = null;
            des_buf = null;
            return nBytesToWrite;
        }
        temp_buf = null;
        des_buf = null;
        return 0;
    }

    @Override
    public int ReadBuffer(byte[] ReadBuffer, int OffsetSize, int nBytesToRead, int ReadTimeOut) {
        UsbEndpoint endpoint;
        int read_size = 0;
        int i = 0;
        if (this.des_dev == null || this.connection == null) {
            return 0;
        }
        try {
            UsbInterface intf = this.des_dev.getInterface(0);
            endpoint = intf.getEndpoint(2);
            boolean forceClaim = true;
            this.connection.claimInterface(intf, forceClaim);
        }
        catch (Exception e) {
            return 0;
        }
        byte[] temp_buf = new byte[ReadBuffer.length];
        read_size = this.connection.bulkTransfer(endpoint, temp_buf, nBytesToRead, ReadTimeOut);
        read_size = this.connection.bulkTransfer(endpoint, temp_buf, nBytesToRead, ReadTimeOut);
        read_size = this.connection.bulkTransfer(endpoint, temp_buf, nBytesToRead, ReadTimeOut);
        if (read_size > 0) {
            i = OffsetSize;
            while (i < OffsetSize + read_size) {
                ReadBuffer[i] = temp_buf[i - OffsetSize];
                ++i;
            }
            temp_buf = null;
            return read_size;
        }
        temp_buf = null;
        return 0;
    }

    @Override
    public int ReadBuffer(byte[] ReadBuffer, int OffsetSize, int nBytesToRead, int ReadTimeOut, int PortNum) {
        UsbEndpoint endpoint;
        int read_size = 0;
        int i = 0;
        if (this.des_dev == null || this.connection == null && PortNum > 0 && PortNum < 3) {
            return 0;
        }
        try {
            UsbInterface intf = this.des_dev.getInterface(0);
            endpoint = intf.getEndpoint(PortNum);
            boolean forceClaim = true;
            this.connection.claimInterface(intf, forceClaim);
        }
        catch (Exception e) {
            return 0;
        }
        byte[] temp_buf = new byte[ReadBuffer.length];
        if (PortNum == 1) {
            read_size = this.connection.bulkTransfer(endpoint, temp_buf, nBytesToRead, ReadTimeOut);
        } else {
            read_size = this.connection.bulkTransfer(endpoint, temp_buf, nBytesToRead, ReadTimeOut);
            read_size = this.connection.bulkTransfer(endpoint, temp_buf, nBytesToRead, ReadTimeOut);
        }
        if (read_size > 0) {
            i = OffsetSize;
            while (i < OffsetSize + read_size) {
                ReadBuffer[i] = temp_buf[i - OffsetSize];
                ++i;
            }
            temp_buf = null;
            return read_size;
        }
        temp_buf = null;
        return 0;
    }

    @Override
    public int CloseDevice() {
        Context activity = this.mActivity;
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
            try {
                activity.unregisterReceiver(this.mUsbReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return 1000;
    }

    public String byte2hex(byte[] buffer) {
        String h = "";
        int i = 0;
        while (i < buffer.length) {
            String temp = Integer.toHexString(buffer[i] & 0xFF);
            if (temp.length() == 1) {
                temp = "0" + temp;
            }
            h = String.valueOf(h) + " " + temp;
            ++i;
        }
        return h;
    }
}

