/* -*- pse-c -*-
 *-----------------------------------------------------------------------------
 * Filename: oswindows.h
 * $Revision: 1.27 $
 *-----------------------------------------------------------------------------
 * 
 * Copyright (2002 - 2012) Intel Corporation All Rights Reserved.
 * The source code, information and material ("Material") contained herein is 
 * owned by Intel Corporation or its suppliers or licensors, and title to such 
 * Material remains with Intel Corporation or its suppliers or licensors. The 
 * Material contains proprietary information of Intel or its suppliers and 
 * licensors. The Material is protected by worldwide copyright laws and treaty 
 * provisions. No part of the Material may be used, copied, reproduced, modified,
 * published, uploaded, posted, transmitted, distributed or disclosed in any way 
 * without Intel's prior express written permission. No license under any patent, 
 * copyright or other intellectual property rights in the Material is granted to 
 * or conferred upon you, either expressly, by implication, inducement, estoppel 
 * or otherwise. Any license under such intellectual property rights must be 
 * express and approved by Intel in writing.
 *
 *-----------------------------------------------------------------------------
 * Description:
 *  This file contains macros and functions required to communicate with the
 *  Windows OS and IEGD driver.
 *-----------------------------------------------------------------------------
 * Authors:
 *  
 *-----------------------------------------------------------------------------
 */

#ifndef _OSWINDOWS_H
#define _OSWINDOWS_H

#include <config.h>
#include "../include/osfunc.h"
#include "resource.h"
#include <afxwin.h>

#define GMCH_REG                    "gmchReg.sys"
#define GMCH_SERVICE_NAME           "GmchRegDev"
#define GMCH_SYMBOLIC_NAME          "gmchReg"
#define CPU_INFO_REG                "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0"
#define CPU_IDENTIFIER              "Identifier"
#define CPU_PROC_NAME_STR           "ProcessorNameString"
#define CPU_VEND_ID                 "VendorIdentifier"
#define TEST_MINI_DLL               "test_mini_dll.dll"
#define BOOTUP_FUNC_NAME            "bootup_sequence"
#define ESCAPE_FUNC_NAME            "test_escape"
#define DISP_SETTINGS_FUNC_NAME     "test_change_display_settings"

#define SYSTEM_BIOS_VERSION_SEGMENT 0xF000
#define SYSTEM_BIOS_VERSION_OFFSET  0x814
#define SYSTEM_BIOS_LENGTH          0x180

#define CHANGE_DISPLAY_SETTINGS_EX    "ChangeDisplaySettingsExA"
typedef LONG (__stdcall *PFNCHANGEDISPLAYSETTINGSEX)(LPCTSTR, LPDEVMODE, HWND, 
					DWORD, LPVOID);


typedef unsigned long (*BOOTUP_FUNC) ();
typedef int (*ESCAPE_FUNC) (
	IN int extension_num,
	IN int escape,
	IN int input_size,
	IN char *input,
	IN int output_size,
	IN char *output);
typedef long (*DISP_SETTINGS_FUNC)(
	IN DEVMODE *dev_mode,
	IN unsigned long flags);


extern bool g_driver_present;
extern bool g_simulation_mode;
extern HMODULE g_lib_hdl;


bool open_device(
	HANDLE *hdl,
	char *device_name);

void close_device(
	HANDLE hdl,
	char *devicename);

BOOL extract_resource(
	IN char *resource_name,
	IN HRSRC h_rsrs);

BOOL load_driver();

BOOL unload_driver();

BOOL os_send_ioctl(
	IN ULONG ioctl_code,
	IN int input_size,
	IN void *input,
	IN int output_size,
	OUT void *output);

bool extend_desktop(
	IN unsigned short new_width,
	IN unsigned short new_height,
	IN unsigned short new_refresh,
	IN unsigned short new_bpp,
	IN unsigned long rel_disp_num);

void detach_display(IN unsigned long rel_disp_num);

bool os_set_mode(
	IN unsigned short width,
	IN unsigned short height,
	IN unsigned short refresh);

long do_change_display_settings(
		char * dev_name,
		DEVMODE *new_mode_ptr,
		DWORD flags);


#define DRIVER_PRESENT_CHECK() if(!g_driver_present) { \
		WRITE_MSG(0, (MSG_ERROR, \
			"ERROR: Driver not present, First install driver by calling" \
			" os_initialize")); \
		ret_val = false; \
	}
#define PRINT_DEVICE_STRING(a) printf("%s", a->DeviceString)
#define PRINT_DEVICE_NAME(a)   printf("%s", a->DeviceName)

#if !SOURCE_CODE_ONLY

#define LOAD_DRIVER()    load_driver()
#define UNLOAD_DRIVER()  unload_driver()

#else

#define LOAD_DRIVER()    true
#define UNLOAD_DRIVER()  true

#endif

#endif
